/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM3
extends AbstractSegment {
    public OM3(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Preferred Coding System");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Valid Coded \"Answers\"");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Normal Text/Codes for Categorical Observations");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Abnormal Text/Codes for Categorical Observations");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Critical Text/Codes for Categorical Observations");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(125)}, "Value Type");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM3 - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm31_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getPreferredCodingSystem() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getOm32_PreferredCodingSystem() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getValidCodedAnswers() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getOm33_ValidCodedAnswers() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE[] getNormalTextCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public CE[] getOm34_NormalTextCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(4, new CE[0]);
        return retVal;
    }

    public int getNormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(4);
    }

    public CE getNormalTextCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public CE getOm34_NormalTextCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getOm34_NormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(4);
    }

    public CE insertNormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE insertOm34_NormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE removeNormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE removeOm34_NormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE[] getAbnormalTextCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public CE[] getOm35_AbnormalTextCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public int getAbnormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(5);
    }

    public CE getAbnormalTextCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public CE getOm35_AbnormalTextCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getOm35_AbnormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(5);
    }

    public CE insertAbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE insertOm35_AbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE removeAbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE removeOm35_AbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE[] getCriticalTextCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(6, new CE[0]);
        return retVal;
    }

    public CE[] getOm36_CriticalTextCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(6, new CE[0]);
        return retVal;
    }

    public int getCriticalTextCodesForCategoricalObservationsReps() {
        return this.getReps(6);
    }

    public CE getCriticalTextCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public CE getOm36_CriticalTextCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getOm36_CriticalTextCodesForCategoricalObservationsReps() {
        return this.getReps(6);
    }

    public CE insertCriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE insertOm36_CriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE removeCriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public CE removeOm36_CriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public ID getValueType() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getOm37_ValueType() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(125));
            }
        }
        return null;
    }
}

