/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EQL
extends AbstractSegment {
    public EQL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 32, new Object[]{this.getMessage()}, "Query Tag");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(106)}, "Query/Response Format Code");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "EQL Query Name");
            this.add(ST.class, true, 1, 4096, new Object[]{this.getMessage()}, "EQL Query Statement");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EQL - this is probably a bug in the source code generator.", e);
        }
    }

    public ST getQueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getEql1_QueryTag() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getQueryResponseFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getEql2_QueryResponseFormatCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getEQLQueryName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getEql3_EQLQueryName() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getEQLQueryStatement() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getEql4_EQLQueryStatement() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(106));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

