/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CCD;
import ca.uhn.hl7v2.model.v25.datatype.CWE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class BLG
extends AbstractSegment {
    public BLG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CCD.class, false, 1, 40, new Object[]{this.getMessage()}, "When to Charge");
            this.add(ID.class, false, 1, 50, new Object[]{this.getMessage(), new Integer(122)}, "Charge Type");
            this.add(CX.class, false, 1, 100, new Object[]{this.getMessage()}, "Account ID");
            this.add(CWE.class, false, 1, 60, new Object[]{this.getMessage()}, "Charge Type Reason");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BLG - this is probably a bug in the source code generator.", e);
        }
    }

    public CCD getWhenToCharge() {
        CCD retVal = (CCD)this.getTypedField(1, 0);
        return retVal;
    }

    public CCD getBlg1_WhenToCharge() {
        CCD retVal = (CCD)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getChargeType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getBlg2_ChargeType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CX getAccountID() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getBlg3_AccountID() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getChargeTypeReason() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getBlg4_ChargeTypeReason() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CCD(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(122));
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

