/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.BRP_O30_TIMING;
import ca.uhn.hl7v2.model.v25.segment.BPO;
import ca.uhn.hl7v2.model.v25.segment.BPX;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class BRP_O30_ORDER
extends AbstractGroup {
    public BRP_O30_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(BRP_O30_TIMING.class, false, true, false);
            this.add(BPO.class, false, false, false);
            this.add(BPX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BRP_O30_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public BRP_O30_TIMING getTIMING() {
        BRP_O30_TIMING retVal = this.getTyped("TIMING", BRP_O30_TIMING.class);
        return retVal;
    }

    public BRP_O30_TIMING getTIMING(int rep) {
        BRP_O30_TIMING retVal = this.getTyped("TIMING", rep, BRP_O30_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<BRP_O30_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", BRP_O30_TIMING.class);
    }

    public void insertTIMING(BRP_O30_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public BRP_O30_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BRP_O30_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO retVal = this.getTyped("BPO", BPO.class);
        return retVal;
    }

    public BPX getBPX() {
        BPX retVal = this.getTyped("BPX", BPX.class);
        return retVal;
    }

    public BPX getBPX(int rep) {
        BPX retVal = this.getTyped("BPX", rep, BPX.class);
        return retVal;
    }

    public int getBPXReps() {
        return this.getReps("BPX");
    }

    public List<BPX> getBPXAll() throws HL7Exception {
        return this.getAllAsList("BPX", BPX.class);
    }

    public void insertBPX(BPX structure, int rep) throws HL7Exception {
        super.insertRepetition("BPX", structure, rep);
    }

    public BPX insertBPX(int rep) throws HL7Exception {
        return (BPX)super.insertRepetition("BPX", rep);
    }

    public BPX removeBPX(int rep) throws HL7Exception {
        return (BPX)super.removeRepetition("BPX", rep);
    }
}

