/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.EQU;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.model.v24.segment.TCC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class TCU_U10
extends AbstractMessage {
    public TCU_U10() {
        this(new DefaultModelClassFactory());
    }

    public TCU_U10(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EQU.class, true, false);
            this.add(TCC.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TCU_U10 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public TCC getTCC() {
        return this.getTyped("TCC", TCC.class);
    }

    public TCC getTCC(int rep) {
        return this.getTyped("TCC", rep, TCC.class);
    }

    public int getTCCReps() {
        return this.getReps("TCC");
    }

    public List<TCC> getTCCAll() throws HL7Exception {
        return this.getAllAsList("TCC", TCC.class);
    }

    public void insertTCC(TCC structure, int rep) throws HL7Exception {
        super.insertRepetition("TCC", structure, rep);
    }

    public TCC insertTCC(int rep) throws HL7Exception {
        return (TCC)super.insertRepetition("TCC", rep);
    }

    public TCC removeTCC(int rep) throws HL7Exception {
        return (TCC)super.removeRepetition("TCC", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

