/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_AUI;
import ca.uhn.hl7v2.model.v23.datatype.CP;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XON;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN1
extends AbstractSegment {
    public IN1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - Insurance");
            this.add(CE.class, false, 1, 8, new Object[]{this.getMessage()}, "Insurance Plan ID");
            this.add(CX.class, true, 1, 59, new Object[]{this.getMessage()}, "Insurance Company ID");
            this.add(XON.class, false, 1, 130, new Object[]{this.getMessage()}, "Insurance Company Name");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Insurance Company Address");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage()}, "Insurance Co. Contact Ppers");
            this.add(XTN.class, false, 3, 40, new Object[]{this.getMessage()}, "Insurance Co Phone Number");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Group Number");
            this.add(XON.class, false, 1, 130, new Object[]{this.getMessage()}, "Group Name");
            this.add(CX.class, false, 1, 12, new Object[]{this.getMessage()}, "Insured's group employer ID");
            this.add(XON.class, false, 1, 130, new Object[]{this.getMessage()}, "Insured's Group Emp Name");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Plan Effective Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Plan Expiration Date");
            this.add(CM_AUI.class, false, 1, 55, new Object[]{this.getMessage()}, "Authorization Information");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(86)}, "Plan Type");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage()}, "Name of Insured");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(63)}, "Insured's Relationship to Patient");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Insured's Date of Birth");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Insured's Address");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(135)}, "Assignment of Benefits");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(173)}, "Coordination of Benefits");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "Coord of Ben. Priority");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(136)}, "Notice of Admission Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Notice of Admission Date");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(136)}, "Rpt of Eigibility Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Rpt of Eligibility Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(93)}, "Release Information Code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Pre-Admit Cert (PAC)");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Verification Date/Time");
            this.add(XPN.class, false, 1, 60, new Object[]{this.getMessage()}, "Verification By");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(98)}, "Type of Agreement Code");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(22)}, "Billing Status");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Lifetime Reserve Days");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Delay before lifetime reserve days");
            this.add(IS.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(42)}, "Company Plan Code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Policy Number");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Policy Deductible");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Policy Limit - Amount");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Policy Limit - Days");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Room Rate - Semi-Private");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Room Rate - Private");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Insured's Employment Status");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Insured's Sex");
            this.add(XAD.class, false, 1, 106, new Object[]{this.getMessage()}, "Insured's Employer Address");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "Verification Status");
            this.add(IS.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(72)}, "Prior Insurance Plan ID");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(309)}, "Coverage Type");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(310)}, "Handicap");
            this.add(CX.class, false, 1, 12, new Object[]{this.getMessage()}, "Insured's ID Number");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IN1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDInsurance() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIn11_SetIDInsurance() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getInsurancePlanID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getIn12_InsurancePlanID() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CX getInsuranceCompanyID() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getIn13_InsuranceCompanyID() {
        CX retVal = (CX)this.getTypedField(3, 0);
        return retVal;
    }

    public XON getInsuranceCompanyName() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XON getIn14_InsuranceCompanyName() {
        XON retVal = (XON)this.getTypedField(4, 0);
        return retVal;
    }

    public XAD getInsuranceCompanyAddress() {
        XAD retVal = (XAD)this.getTypedField(5, 0);
        return retVal;
    }

    public XAD getIn15_InsuranceCompanyAddress() {
        XAD retVal = (XAD)this.getTypedField(5, 0);
        return retVal;
    }

    public XPN getInsuranceCoContactPpers() {
        XPN retVal = (XPN)this.getTypedField(6, 0);
        return retVal;
    }

    public XPN getIn16_InsuranceCoContactPpers() {
        XPN retVal = (XPN)this.getTypedField(6, 0);
        return retVal;
    }

    public XTN[] getInsuranceCoPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(7, new XTN[0]);
        return retVal;
    }

    public XTN[] getIn17_InsuranceCoPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(7, new XTN[0]);
        return retVal;
    }

    public int getInsuranceCoPhoneNumberReps() {
        return this.getReps(7);
    }

    public XTN getInsuranceCoPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public XTN getIn17_InsuranceCoPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getIn17_InsuranceCoPhoneNumberReps() {
        return this.getReps(7);
    }

    public XTN insertInsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN insertIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN removeInsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public XTN removeIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public ST getGroupNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getIn18_GroupNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public XON getGroupName() {
        XON retVal = (XON)this.getTypedField(9, 0);
        return retVal;
    }

    public XON getIn19_GroupName() {
        XON retVal = (XON)this.getTypedField(9, 0);
        return retVal;
    }

    public CX getInsuredSGroupEmployerID() {
        CX retVal = (CX)this.getTypedField(10, 0);
        return retVal;
    }

    public CX getIn110_InsuredSGroupEmployerID() {
        CX retVal = (CX)this.getTypedField(10, 0);
        return retVal;
    }

    public XON getInsuredSGroupEmpName() {
        XON retVal = (XON)this.getTypedField(11, 0);
        return retVal;
    }

    public XON getIn111_InsuredSGroupEmpName() {
        XON retVal = (XON)this.getTypedField(11, 0);
        return retVal;
    }

    public DT getPlanEffectiveDate() {
        DT retVal = (DT)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getIn112_PlanEffectiveDate() {
        DT retVal = (DT)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getPlanExpirationDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getIn113_PlanExpirationDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public CM_AUI getAuthorizationInformation() {
        CM_AUI retVal = (CM_AUI)this.getTypedField(14, 0);
        return retVal;
    }

    public CM_AUI getIn114_AuthorizationInformation() {
        CM_AUI retVal = (CM_AUI)this.getTypedField(14, 0);
        return retVal;
    }

    public IS getPlanType() {
        IS retVal = (IS)this.getTypedField(15, 0);
        return retVal;
    }

    public IS getIn115_PlanType() {
        IS retVal = (IS)this.getTypedField(15, 0);
        return retVal;
    }

    public XPN getNameOfInsured() {
        XPN retVal = (XPN)this.getTypedField(16, 0);
        return retVal;
    }

    public XPN getIn116_NameOfInsured() {
        XPN retVal = (XPN)this.getTypedField(16, 0);
        return retVal;
    }

    public IS getInsuredSRelationshipToPatient() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getIn117_InsuredSRelationshipToPatient() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public TS getInsuredSDateOfBirth() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public TS getIn118_InsuredSDateOfBirth() {
        TS retVal = (TS)this.getTypedField(18, 0);
        return retVal;
    }

    public XAD getInsuredSAddress() {
        XAD retVal = (XAD)this.getTypedField(19, 0);
        return retVal;
    }

    public XAD getIn119_InsuredSAddress() {
        XAD retVal = (XAD)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getAssignmentOfBenefits() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getIn120_AssignmentOfBenefits() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getCoordinationOfBenefits() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getIn121_CoordinationOfBenefits() {
        IS retVal = (IS)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getCoordOfBenPriority() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getIn122_CoordOfBenPriority() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getNoticeOfAdmissionCode() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getIn123_NoticeOfAdmissionCode() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public DT getNoticeOfAdmissionDate() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public DT getIn124_NoticeOfAdmissionDate() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getRptOfEigibilityCode() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getIn125_RptOfEigibilityCode() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getRptOfEligibilityDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public DT getIn126_RptOfEligibilityDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public IS getReleaseInformationCode() {
        IS retVal = (IS)this.getTypedField(27, 0);
        return retVal;
    }

    public IS getIn127_ReleaseInformationCode() {
        IS retVal = (IS)this.getTypedField(27, 0);
        return retVal;
    }

    public ST getPreAdmitCert() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public ST getIn128_PreAdmitCert() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public TS getVerificationDateTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public TS getIn129_VerificationDateTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public XPN getVerificationBy() {
        XPN retVal = (XPN)this.getTypedField(30, 0);
        return retVal;
    }

    public XPN getIn130_VerificationBy() {
        XPN retVal = (XPN)this.getTypedField(30, 0);
        return retVal;
    }

    public IS getTypeOfAgreementCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public IS getIn131_TypeOfAgreementCode() {
        IS retVal = (IS)this.getTypedField(31, 0);
        return retVal;
    }

    public IS getBillingStatus() {
        IS retVal = (IS)this.getTypedField(32, 0);
        return retVal;
    }

    public IS getIn132_BillingStatus() {
        IS retVal = (IS)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getLifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getIn133_LifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getDelayBeforeLifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public NM getIn134_DelayBeforeLifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public IS getCompanyPlanCode() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public IS getIn135_CompanyPlanCode() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public ST getPolicyNumber() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public ST getIn136_PolicyNumber() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public CP getPolicyDeductible() {
        CP retVal = (CP)this.getTypedField(37, 0);
        return retVal;
    }

    public CP getIn137_PolicyDeductible() {
        CP retVal = (CP)this.getTypedField(37, 0);
        return retVal;
    }

    public CP getPolicyLimitAmount() {
        CP retVal = (CP)this.getTypedField(38, 0);
        return retVal;
    }

    public CP getIn138_PolicyLimitAmount() {
        CP retVal = (CP)this.getTypedField(38, 0);
        return retVal;
    }

    public NM getPolicyLimitDays() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public NM getIn139_PolicyLimitDays() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public CP getRoomRateSemiPrivate() {
        CP retVal = (CP)this.getTypedField(40, 0);
        return retVal;
    }

    public CP getIn140_RoomRateSemiPrivate() {
        CP retVal = (CP)this.getTypedField(40, 0);
        return retVal;
    }

    public CP getRoomRatePrivate() {
        CP retVal = (CP)this.getTypedField(41, 0);
        return retVal;
    }

    public CP getIn141_RoomRatePrivate() {
        CP retVal = (CP)this.getTypedField(41, 0);
        return retVal;
    }

    public CE getInsuredSEmploymentStatus() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public CE getIn142_InsuredSEmploymentStatus() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public IS getInsuredSSex() {
        IS retVal = (IS)this.getTypedField(43, 0);
        return retVal;
    }

    public IS getIn143_InsuredSSex() {
        IS retVal = (IS)this.getTypedField(43, 0);
        return retVal;
    }

    public XAD getInsuredSEmployerAddress() {
        XAD retVal = (XAD)this.getTypedField(44, 0);
        return retVal;
    }

    public XAD getIn144_InsuredSEmployerAddress() {
        XAD retVal = (XAD)this.getTypedField(44, 0);
        return retVal;
    }

    public ST getVerificationStatus() {
        ST retVal = (ST)this.getTypedField(45, 0);
        return retVal;
    }

    public ST getIn145_VerificationStatus() {
        ST retVal = (ST)this.getTypedField(45, 0);
        return retVal;
    }

    public IS getPriorInsurancePlanID() {
        IS retVal = (IS)this.getTypedField(46, 0);
        return retVal;
    }

    public IS getIn146_PriorInsurancePlanID() {
        IS retVal = (IS)this.getTypedField(46, 0);
        return retVal;
    }

    public IS getCoverageType() {
        IS retVal = (IS)this.getTypedField(47, 0);
        return retVal;
    }

    public IS getIn147_CoverageType() {
        IS retVal = (IS)this.getTypedField(47, 0);
        return retVal;
    }

    public IS getHandicap() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public IS getIn148_Handicap() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public CX getInsuredSIDNumber() {
        CX retVal = (CX)this.getTypedField(49, 0);
        return retVal;
    }

    public CX getIn149_InsuredSIDNumber() {
        CX retVal = (CX)this.getTypedField(49, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new XON(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XPN(this.getMessage());
            }
            case 6: {
                return new XTN(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new XON(this.getMessage());
            }
            case 9: {
                return new CX(this.getMessage());
            }
            case 10: {
                return new XON(this.getMessage());
            }
            case 11: {
                return new DT(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new CM_AUI(this.getMessage());
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(86));
            }
            case 15: {
                return new XPN(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(63));
            }
            case 17: {
                return new TS(this.getMessage());
            }
            case 18: {
                return new XAD(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(135));
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(173));
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new DT(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 25: {
                return new DT(this.getMessage());
            }
            case 26: {
                return new IS(this.getMessage(), new Integer(93));
            }
            case 27: {
                return new ST(this.getMessage());
            }
            case 28: {
                return new TS(this.getMessage());
            }
            case 29: {
                return new XPN(this.getMessage());
            }
            case 30: {
                return new IS(this.getMessage(), new Integer(98));
            }
            case 31: {
                return new IS(this.getMessage(), new Integer(22));
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new NM(this.getMessage());
            }
            case 34: {
                return new IS(this.getMessage(), new Integer(42));
            }
            case 35: {
                return new ST(this.getMessage());
            }
            case 36: {
                return new CP(this.getMessage());
            }
            case 37: {
                return new CP(this.getMessage());
            }
            case 38: {
                return new NM(this.getMessage());
            }
            case 39: {
                return new CP(this.getMessage());
            }
            case 40: {
                return new CP(this.getMessage());
            }
            case 41: {
                return new CE(this.getMessage());
            }
            case 42: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 43: {
                return new XAD(this.getMessage());
            }
            case 44: {
                return new ST(this.getMessage());
            }
            case 45: {
                return new IS(this.getMessage(), new Integer(72));
            }
            case 46: {
                return new IS(this.getMessage(), new Integer(309));
            }
            case 47: {
                return new IS(this.getMessage(), new Integer(310));
            }
            case 48: {
                return new CX(this.getMessage());
            }
        }
        return null;
    }
}

