/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.date.TimeZoneSource;
import java.util.TimeZone;

public final class PerThreadTimeZoneStrategy
implements TimeZoneSource {
    private ThreadLocal<TimeZone> timeZone;
    private final TimeZone _default;

    public PerThreadTimeZoneStrategy() {
        this(TimeZone.getDefault());
    }

    public PerThreadTimeZoneStrategy(TimeZone tz) {
        if (tz == null) {
            throw new IllegalArgumentException("tz is null");
        }
        this._default = tz;
        this.timeZone = new ThreadLocal<TimeZone>(){

            @Override
            protected TimeZone initialValue() {
                return PerThreadTimeZoneStrategy.this._default;
            }
        };
    }

    @Override
    public TimeZone get() {
        return this.timeZone.get();
    }

    @Override
    public void set(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException();
        }
        this.timeZone.set(timeZone);
    }

    @Override
    public void reset() {
        this.timeZone.remove();
    }
}

