/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.config;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.config.ConfigKey;
import ca.infodata.util1.config.ConfigurationException;
import java.util.logging.Logger;
import org.apache.commons.lang.math.NumberUtils;

public class BooleanConfigKey
extends ConfigKey<Boolean> {
    private static final Logger logger = Logger.getLogger(BooleanConfigKey.class.getName());

    public BooleanConfigKey(String ... keys) {
        super(keys);
    }

    public BooleanConfigKey setDefaultValue(Boolean value) {
        return (BooleanConfigKey)super.setDefaultValue(value);
    }

    @Override
    protected Boolean convertFoundValueToT(Object value) {
        if (value == null) {
            return (Boolean)this.getDefaultValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (StringUtils.isBlank(s)) {
                return (Boolean)this.getDefaultValue();
            }
            if (NumberUtils.isNumber(s)) {
                return Integer.parseInt(s) != 0;
            }
            return Boolean.valueOf((String)value);
        }
        logger.severe("invalid value type for property with key " + this + ". expected boolean was " + value.getClass().getName() + ". using default value.");
        return (Boolean)this.getDefaultValue();
    }

    @Override
    Boolean getCheckedProperty() throws ConfigurationException {
        Boolean b = (Boolean)this.getProperty();
        if (b == null) {
            throw new ConfigurationException(this.getKey() + " boolean config key cannot be null");
        }
        return b;
    }
}

