/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;

public class LongRange
extends Range<Long> {
    private static final long serialVersionUID = 1L;

    public LongRange() {
    }

    public LongRange(Long start, Long end, RangeNotation notation) {
        super(start, end, notation);
    }

    @Override
    public boolean intersect(Range<Long> range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        Long start1 = this.toClosedStart((Long)this.start, this.notation);
        Long end1 = this.toClosedEnd((Long)this.end, this.notation);
        Long start2 = this.toClosedStart((Long)range.start, range.notation);
        Long end2 = this.toClosedEnd((Long)range.end, range.notation);
        return RangeNotation.CLOSED.inRange(start2, start1, end1) || RangeNotation.CLOSED.inRange(end2, start1, end1) || RangeNotation.CLOSED.inRange(start1, start2, end2) || RangeNotation.CLOSED.inRange(end1, start2, end2);
    }

    private Long toClosedEnd(Long end, RangeNotation notation) {
        switch (notation) {
            case CLOSED: 
            case RIGHT_CLOSED: {
                return end;
            }
            case OPEN: 
            case LEFT_CLOSED: {
                return end - 1L;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    private Long toClosedStart(Long start, RangeNotation notation) {
        switch (notation) {
            case CLOSED: 
            case LEFT_CLOSED: {
                return start;
            }
            case RIGHT_CLOSED: 
            case OPEN: {
                return start + 1L;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }
}

