/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JoinList {
    private final ArrayList<String> list;
    private final String sep;
    private int sizeHint;
    private boolean noDuplicate;
    private boolean trim;
    private boolean allowBlank;
    private String prefix;
    private String suffix;

    public JoinList(String sep, Collection<?> c) {
        this(sep, c == null ? 0 : c.size());
        if (c != null) {
            for (Object e : c) {
                this.genericAdd(e);
            }
        }
    }

    public JoinList(String sep, int[] c) {
        this(sep, c == null ? 0 : c.length);
        if (c != null) {
            int[] nArray = c;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer e = nArray[i];
                this.genericAdd(e);
            }
        }
    }

    public JoinList(String sep, Object ... items) {
        this(sep, items.length);
        this.addArray(items);
    }

    public JoinList(String sep) {
        if (sep == null) {
            throw new NullPointerException("sep");
        }
        this.sep = sep;
        this.list = new ArrayList();
        this.sizeHint = -1;
    }

    public JoinList(String sep, int size) {
        if (sep == null) {
            throw new NullPointerException("sep");
        }
        this.sep = sep;
        this.list = new ArrayList(size);
        this.sizeHint = -1;
    }

    public JoinList setNoDuplicate(boolean b) {
        this.noDuplicate = b;
        return this;
    }

    public JoinList setTrim(boolean b) {
        this.trim = b;
        return this;
    }

    private boolean evaluate(String s) {
        return (this.allowBlank || !StringUtils.isBlank(s)) && (!this.noDuplicate || !this.list.contains(s));
    }

    public JoinList addUpperCase(String s) {
        if (s != null) {
            this.add(s.toUpperCase());
        }
        return this;
    }

    public JoinList add(JoinList list) {
        if (list != null) {
            for (String s : list.iterable()) {
                this.add(s);
            }
        }
        return this;
    }

    public JoinList addNTimes(String s, int n) {
        for (int i = 0; i < n; ++i) {
            this.add(s);
        }
        return this;
    }

    public JoinList add(int s) {
        return this.add(String.valueOf(s));
    }

    public JoinList addAll(Collection<String> c) {
        for (String s : c) {
            this.add(s);
        }
        return this;
    }

    public JoinList add(String s) {
        if (this.evaluate(s)) {
            this.internAdd(s);
        }
        return this;
    }

    public JoinList add(String prefix, String s) {
        if (this.evaluate(s)) {
            this.internAdd(prefix + s);
        }
        return this;
    }

    public JoinList add(Class<?> c) {
        if (c != null) {
            return this.add(c.getSimpleName());
        }
        return this;
    }

    public JoinList addArray(Object ... items) {
        for (Object object : items) {
            this.genericAdd(object);
        }
        return this;
    }

    public JoinList addArray2(Object[] items) {
        for (Object object : items) {
            this.genericAdd(object);
        }
        return this;
    }

    private void genericAdd(Object object) {
        if (object instanceof String) {
            this.add((String)object);
        } else if (object instanceof Class) {
            this.add((Class)object);
        } else {
            this.add(object == null ? null : object.toString());
        }
    }

    private boolean internAdd(String s) {
        this.sizeHint = -1;
        if (this.prefix != null) {
            s = this.prefix + s;
        }
        if (this.suffix != null) {
            s = s + this.suffix;
        }
        if (this.trim) {
            s = s.trim();
        }
        this.list.add(s);
        return true;
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        this.computeSizeHint();
        StringBuilder builder = new StringBuilder(this.sizeHint);
        Iterator<String> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            builder.append(next == null ? "" : next);
            if (!iterator.hasNext()) continue;
            builder.append(this.sep);
        }
        return builder.toString();
    }

    private void computeSizeHint() {
        if (this.sizeHint == -1) {
            this.sizeHint = this.sep.length() * this.list.size();
            if (this.sizeHint != 0) {
                --this.sizeHint;
            }
            for (String s : this.list) {
                if (s == null) continue;
                this.sizeHint += s.length();
            }
        }
    }

    public boolean isAllowBlank() {
        return this.allowBlank;
    }

    public void setAllowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public JoinList setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public JoinList setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public List<String> toList() {
        return (List)this.list.clone();
    }

    public Iterable<String> iterable() {
        return this.list;
    }
}

