/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.site;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SiteCombo
extends MyCombo<XSite> {
    private static final Logger logger = Logger.getLogger(SiteCombo.class.getName());
    private static final List<SiteCombo> instances = new CopyOnWriteArrayList<SiteCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<SiteCombo> toRemoveList = new ArrayList<SiteCombo>();
                for (SiteCombo combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill();
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;
    private boolean cnull;
    private XSite snull;

    static {
        CompletionComboAccessorClient.addListener((String)XSite.type, (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public SiteCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.cnull = (style | 0x10000) == style;
        this.setAutoComplete(false);
        this.setLabelProvider((ProviderAR)new ProviderAR<XSite, String>(){

            public String get(XSite c) {
                String text = c == null || c.getText() == null ? "" : c.getText();
                boolean showId = Application.get().getGlobalInstances().inDebugMode();
                if (showId && c != null) {
                    text = c.getId() + " " + text;
                }
                return text;
            }
        });
        this.setDisplayPredicate((PredicateA)new PredicateA<XSite>(){

            public boolean evaluate(XSite c) {
                return c != null && c.isActive();
            }
        });
        this.setTextLimit(100);
        this.fill();
        instances.add(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove((Object)SiteCombo.this);
            }
        });
    }

    protected void fill() {
        if (Application.get().getGlobalInstances().getSession() == null) {
            this.fill(new ArrayList<XSite>(1));
            return;
        }
        this.fill(SitePlugin.getDefault().getSites().collect(Collectors.toList()));
    }

    private void fill(List<XSite> sites) {
        String text = this.getText();
        XSite selection = this.getSelection();
        this.removeAllNoNotify();
        this.snull = null;
        if (this.cnull) {
            this.snull = new XSite();
            this.snull.initialize();
            this.snull.setIsDeleted(Boolean.valueOf(false));
            this.snull.setIsWorkSite(Boolean.valueOf(true));
            this.snull.setNeutral();
            sites.add(0, this.snull);
        }
        Collections.sort(sites, new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                return o1.getText().compareToIgnoreCase(o2.getText());
            }
        });
        this.setItems(sites);
        if (selection != null) {
            this.selectNoNotify(selection);
        } else {
            this.setTextNoNotify(text);
        }
    }

    public void select(XSite item) {
        if (this.contains(item)) {
            super.select((Object)item);
        } else {
            this.add(item);
            super.select((Object)item);
        }
    }

    public XSite getSelection() {
        XSite selection = (XSite)super.getSelection();
        if (selection == null || selection.getId() == null || selection.getId() == -1) {
            return null;
        }
        return selection;
    }
}

