/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientImageAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageContainer;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.XLabelDefTable;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.DataObjectListAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.EnumWithValueAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchControlAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientSearchText;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteComboASearchAdapter;
import ca.infodata.ofys.ui.person.user.UserComboForSelection;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.LocalDateRange;
import java.util.Collection;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ScanSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(ScanSearchComposite.class.getName());
    private MyLabel lblName;
    private MyMaskedText txtName;
    private MyLabel lblResultType;
    private MyCombo<XPatientImageResultType> cmbResultType;
    private MyLabel lblSeenStatus;
    private MyCombo<XPatientImageProfessionnalStatus> cmbSeenStatus;
    private MyLabel lblDocumentDate;
    private MyLabel lblDocumentDateSeparator;
    private MyCalendarText txtDocumentDateFrom;
    private MyCalendarText txtDocumentDateTo;
    private MyLabel lblCreationDate;
    private MyLabel lblCreationDateSeparator;
    private MyCalendarText txtCreationDateFrom;
    private MyCalendarText txtCreationDateTo;
    private MyLabel lblPatient;
    private PatientSearchText txtPatient;
    private MyLabel lblProfessionnal;
    private ProfessionalBySiteCombo cmbProfessionnal;
    private MyLabel lblUser;
    private UserComboForSelection cmbUser;
    private XLabelDefTable listLabel;

    public ScanSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
    }

    public void setFocus() {
        this.setVisible(true);
        this.txtName.setFocus();
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = true;
        this.templateType = XCompletionProposalType.SCAN_SEARCH;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(false);
        FontAwareSection section = new FontAwareSection(parent, 2114, toolkit);
        toolkit.createCompositeSeparator((Composite)section);
        section.setText(Messages.getString((String)"CRITERES", (String[])new String[0]));
        Composite sectionComposite = toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionComposite);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        section.setLayoutData((Object)data);
        parent = sectionComposite;
        layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.lblName = new MyLabel(parent, Messages.getString((String)"NOM", (String[])new String[0]), 16384, toolkit);
        this.lblProfessionnal = new MyLabel(parent, Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]), 16384, toolkit);
        this.lblPatient = new MyLabel(parent, Messages.getString((String)"PATIENT", (String[])new String[0]), 16384, toolkit);
        this.lblResultType = new MyLabel(parent, Messages.getString((String)"NORMALITE", (String[])new String[0]), 16384, toolkit);
        this.lblSeenStatus = new MyLabel(parent, Messages.getString((String)"VU", (String[])new String[0]), 16384, toolkit);
        this.txtName = new MyMaskedText(parent, 4, toolkit);
        this.addSearchControl("txtName", (IControl)this.txtName);
        this.lblDocumentDate = new MyLabel(parent, Messages.getString((String)"DATE_ATTRIBUEE_AU_DOCUMENT", (String[])new String[0]), 16384, toolkit);
        this.lblDocumentDateSeparator = new MyLabel(parent, " - ", 0x1000000, toolkit);
        this.txtDocumentDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.addSearchControl("txtDocumentDateFrom", (IControl)this.txtDocumentDateFrom);
        this.txtDocumentDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.addSearchControl("txtDocumentDateTo", (IControl)this.txtDocumentDateTo);
        this.lblCreationDate = new MyLabel(parent, Messages.getString((String)"DATE_DE_CREATION_DU_DOCUMENT", (String[])new String[0]), 16384, toolkit);
        this.lblCreationDateSeparator = new MyLabel(parent, " - ", 0x1000000, toolkit);
        this.txtCreationDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.addSearchControl("txtCreationDateFrom", (IControl)this.txtCreationDateFrom);
        this.txtCreationDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.addSearchControl("txtCreationDateTo", (IControl)this.txtCreationDateTo);
        this.cmbResultType = new MyCombo(parent, 8, toolkit);
        this.cmbResultType.setItemsWithNull((Object[])XPatientImageResultType.values());
        this.addSearchControl("cmbResultType", (IControl)this.cmbResultType, (SearchControlAdapter)new EnumWithValueAdapter(XPatientImageResultType.class));
        this.cmbSeenStatus = new MyCombo(parent, 8, toolkit);
        this.cmbSeenStatus.setItems((Object[])XPatientImageProfessionnalStatus.values());
        this.addSearchControl("cmbSeenStatus", (IControl)this.cmbSeenStatus, (SearchControlAdapter)new EnumWithValueAdapter(XPatientImageProfessionnalStatus.class));
        this.cmbSeenStatus.setDefaultSelection((Object)XPatientImageProfessionnalStatus.SEEN);
        this.cmbProfessionnal = new ProfessionalBySiteCombo(parent, 65544, toolkit);
        this.cmbProfessionnal.fill();
        this.addSearchControl("cmbProfessionnal", (IControl)this.cmbProfessionnal, (SearchControlAdapter)new ProfessionalBySiteComboASearchAdapter(this.cmbProfessionnal));
        this.lblUser = new MyLabel(parent, Messages.getString((String)"UTILISATEUR", (String[])new String[0]), 16384, toolkit);
        this.cmbUser = new UserComboForSelection(parent, 8);
        this.cmbUser.fill(true);
        this.addSearchControl("cmbUser", (IControl)this.cmbUser.getControl(), (SearchControlAdapter)new DataObjectListAdapter((Collection)PersonUiPlugin.getDefault().getUsers()));
        this.txtPatient = new PatientSearchText(parent, 4096, toolkit);
        this.addSearchControl("txtPatient", (IControl)this.txtPatient);
        MyLabel lblLabels = new MyLabel(parent, Messages.getString((String)"MOTS_CLES", (String[])new String[0]), 16384, toolkit);
        this.listLabel = new XLabelDefTable(parent);
        this.listLabel.fill(XLabelResType.PATIENT_IMAGE);
        this.addSearchControl("listLabel", (IControl)this.listLabel, (SearchControlAdapter)new DataObjectListAdapter((Collection)this.listLabel.getItems()));
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblDocumentDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDocumentDate.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.txtDocumentDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDocumentDate.getControl());
        data.left = new FormAttachment(48);
        data.right = new FormAttachment(52);
        this.lblDocumentDateSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDocumentDate.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        this.txtDocumentDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtDocumentDateFrom);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblCreationDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCreationDate.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.txtCreationDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCreationDate.getControl());
        data.left = new FormAttachment(48);
        data.right = new FormAttachment(52);
        this.lblCreationDateSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCreationDate.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        this.txtCreationDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtCreationDateFrom.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.lblResultType.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblResultType.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.cmbResultType.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtCreationDateFrom.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        this.lblSeenStatus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblSeenStatus.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        this.cmbSeenStatus.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbResultType.getControl());
        data.left = new FormAttachment(0);
        this.lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.lblUser.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblUser.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.cmbUser.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbUser.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.lblProfessionnal.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProfessionnal.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.cmbProfessionnal.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.cmbProfessionnal.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProfessionnal.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(48);
        this.cmbProfessionnal.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.cmbProfessionnal.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPatient.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbSeenStatus.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        lblLabels.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblLabels.getControl());
        data.left = new FormAttachment(52);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(this.lblPatient.getControl());
        this.listLabel.setLayoutData((Object)data);
    }

    protected void search() throws ErrorWhileSearchingException {
        block6: {
            XScanImageContainer container = new XScanImageContainer(Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength().intValue());
            if (this.cmbResultType.getSelection() != null) {
                container.setResults(EnumSet.of((XPatientImageResultType)this.cmbResultType.getSelection()));
            }
            if (this.cmbSeenStatus.getSelection() != null) {
                container.setStatus(EnumSet.of((XPatientImageProfessionnalStatus)this.cmbSeenStatus.getSelection()));
            }
            container.setDocumentDateRange(new LocalDateRange(this.txtDocumentDateFrom.getDate(), this.txtDocumentDateTo.getDate(), RangeNotation.CLOSED));
            container.setCreationDateRange(new LocalDateRange(this.txtCreationDateFrom.getDate(), this.txtCreationDateTo.getDate(), RangeNotation.CLOSED));
            container.setProfessionnal(this.cmbProfessionnal.getSelection());
            container.setPatient((IPatient)this.txtPatient.getDataObject());
            XBaseUser user = this.cmbUser.getSelection();
            container.setIdUser(user == null ? null : user.getId());
            container.setName(this.txtName.getText());
            container.setLabelDefs(this.listLabel.getCheckedSelection());
            JobCallback callback = null;
            try {
                callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(ReturnObject response) {
                        ScanSearchComposite.this.searchResponse((XScanImageContainer)response.getObj());
                    }

                    public void exception(Exception e) {
                        super.exception(e);
                        ScanSearchComposite.this.searchResponse(null);
                    }
                };
                PatientImageAccessorClient.getInstance().findBasePatientImage(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, container);
            }
            catch (CannotConnectToServerException e) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
                throw new ErrorWhileSearchingException((Exception)((Object)e));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                if (callback == null || callback.killed()) break block6;
                callback.kill();
            }
        }
    }

    private void searchResponse(final XScanImageContainer container) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!ScanSearchComposite.this.parent.isDisposed()) {
                        XBasePatientImage[] list = container == null ? null : container.getBaseImages();
                        SearchItem[] items = new SearchItem[list == null ? 0 : list.length];
                        int i = 0;
                        while (i < items.length) {
                            XBasePatientImage image = list[i];
                            items[i] = ScanSearchComposite.this.txtPatient.getDataObject() != null ? new SearchItem((Object)image, MessageUtil.getTranslation((String)image.getStrWithoutPatient())) : new SearchItem((Object)image, MessageUtil.getTranslation((String)image.getStr()));
                            ++i;
                        }
                        if (Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength() < i) {
                            ScanSearchComposite.this.setMessage(MSG_TROP_DONNEES);
                        } else if (i == 0) {
                            ScanSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            ScanSearchComposite.this.txtName.setFocus();
                        } else {
                            ScanSearchComposite.this.setMessage(null);
                        }
                        ScanSearchComposite.this.loadSearchListInTable(items);
                        ScanSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                }
            }
        });
    }

    protected void processSelection(SearchItem item) {
        IDDataObject dataObject;
        IEditorPart part;
        if (this.getReferenceControl() instanceof IReferenceControl) {
            return;
        }
        if (item != null && (part = BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)(dataObject = new IDDataObject(((IDataObject)item.getData()).getId(), XPatientImage.class, item.getText()[0]))))) != null) {
            this.getEditorsFromSearchItem().put(item, part);
        }
    }

    protected void showContextMenu(Control parent) {
    }

    public void reset() {
        super.reset();
        this.txtName.clear();
        this.txtDocumentDateFrom.setDate(null);
        this.txtDocumentDateTo.setDate(null);
        this.txtPatient.setDataObject(null);
        this.cmbResultType.selectNone();
    }

    protected void createNew() {
        throw new UnsupportedOperationException();
    }

    public void setPatient(IPatient patient) {
        this.txtPatient.setDataObject((IDataObject)PatientUtil.getBasePatient((Object)patient));
    }

    public void setProfessionnal(XBaseProfessionnal professionnal) {
        if (professionnal == null) {
            this.cmbProfessionnal.selectNone();
        } else {
            this.cmbProfessionnal.select(professionnal);
        }
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }
}

