/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.dsq;

import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import ca.infodata.dsq.domain.labo.getlist.LaboReportHeader;
import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportHeaderFlat;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.dsq.controller.ConsentControllerCallback;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientSearchText;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.scan.dsq.GetLaboListController;
import ca.infodata.ofys.ui.scan.dsq.GetListControllerCallback;
import ca.infodata.ofys.ui.scan.dsq.LaboReportHeaderImageElement;
import ca.infodata.ofys.ui.scan.singleview.LaboAndScanSingleViewEditor;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GetLaboListComposite
extends BaseSearchComposite
implements GetListControllerCallback,
ConsentControllerCallback {
    private static final Logger logger = Logger.getLogger(GetLaboListComposite.class.getName());
    private MyLabel lblDebut;
    private MyLabel lblFin;
    private MyCalendarText txtDateFrom;
    private MyCalendarText txtDateTo;
    private MyLabel lblPatient;
    private PatientSearchText txtPatient;
    private GetLaboListController listController;
    private static final String consentMessageKey = "consent";

    public GetLaboListComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        BaseDSQAction dsq = new BaseDSQAction();
        this.listController = new GetLaboListController(this, dsq, new FindCandidateAction(), null, null);
        this.txtDateFrom.setDate((IPartialDate)this.listController.getStart());
        this.txtDateTo.setDate((IPartialDate)this.listController.getEnd());
    }

    public void setFocus() {
        this.setVisible(true);
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = false;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(false);
        this.lblDebut = new MyLabel(parent, Messages.getString((String)"DEBUT", (String[])new String[0]), 16384, toolkit);
        this.lblFin = new MyLabel(parent, Messages.getString((String)"FIN", (String[])new String[0]), 16384, toolkit);
        this.txtDateFrom = new MyCalendarText(parent, 0, toolkit, true);
        this.txtDateFrom.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                GetLaboListComposite.this.listController.setStart(date);
            }
        });
        this.txtDateTo = new MyCalendarText(parent, 0, toolkit, true);
        this.txtDateTo.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                GetLaboListComposite.this.listController.setEnd(date);
            }
        });
        this.lblPatient = new MyLabel(parent, Messages.getString((String)"PATIENT", (String[])new String[0]), 16384, toolkit);
        this.txtPatient = new PatientSearchText(parent, 4096, toolkit);
        this.txtPatient.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject dataObject) {
                IPatient patient = PatientUtil.getIPatientOrBasePatient((Object)dataObject);
                GetLaboListComposite.this.listController.setPatient(patient);
                PersonUiPlugin.getDefault().setCurrentPatient(patient);
            }
        });
        FontAwareLabel lblDSQDisclaimer = new FontAwareLabel(parent, "Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)", 0x1000040, toolkit);
        lblDSQDisclaimer.setFont(-1, 2);
        int iTop = 1;
        FormLayout layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblDebut.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtDateTo.getControl(), 0, 16384);
        this.lblFin.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDebut.getControl(), iTop);
        data.left = new FormAttachment(0);
        this.txtDateFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDebut.getControl(), iTop);
        data.left = new FormAttachment(this.txtDateFrom.getControl());
        this.txtDateTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateTo.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.lblPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPatient.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtPatient);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblDSQDisclaimer.setLayoutData((Object)data);
    }

    protected void search() throws ErrorWhileSearchingException {
        try {
            this.clearMessage();
            this.listController.list();
        }
        catch (Exception e) {
            throw new ErrorWhileSearchingException(e);
        }
    }

    @Override
    public void list(DsqCallback<QueryContinuationResult> dsqCallback) {
        if (!this.processExceptionOrMessage("default", dsqCallback)) {
            this.searchResponse((QueryContinuationResult)dsqCallback.result);
        }
    }

    private boolean processExceptionOrMessage(String key, final DsqCallback<?> dsqCallback) {
        if (dsqCallback.exception != null || StringUtils.isNotBlank((String)dsqCallback.message)) {
            this.getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String message = dsqCallback.message;
                    if (dsqCallback.exception != null) {
                        message = StringUtils.isNotBlank((String)dsqCallback.exception.getMessage()) ? dsqCallback.exception.getMessage() : dsqCallback.exception.getClass().getSimpleName();
                    }
                    GetLaboListComposite.this.addMessage(message);
                }
            });
            return true;
        }
        return false;
    }

    public String getConsent(DsqCallback<CandidateConsentDirective> dsqCallback) {
        if (!this.processExceptionOrMessage(consentMessageKey, dsqCallback)) {
            final CandidateConsentDirective consent = (CandidateConsentDirective)dsqCallback.result;
            if (consent != null && consent.hasPastConsentRefusal()) {
                this.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GetLaboListComposite.this.addMessage(GetLaboListComposite.consentMessageKey, "Date de fin du refus : " + DateUtil.nonThreadSafeFormat((Long)(consent.getEffectiveStartTime() - TimeUnit.SECONDS.toMillis(1L)), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                });
            }
            if (consent == null || !consent.hasAccepted()) {
                this.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GetLaboListComposite.this.addMessage(GetLaboListComposite.consentMessageKey, "L'usager refuse de participer au DSQ");
                    }
                });
            }
        }
        return null;
    }

    private void searchResponse(final QueryContinuationResult result) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!GetLaboListComposite.this.getControl().isDisposed()) {
                        List<Object> list;
                        if (result != null) {
                            list = GetLaboListComposite.orderSearchResults(result);
                            if (result.resultTotalQuantity == null || result.resultTotalQuantity == 0) {
                                GetLaboListComposite.this.addMessage(MSG_AUCUNES_DONNEES);
                            } else if (result.resultCurrentQuantity.intValue() != result.resultTotalQuantity.intValue()) {
                                GetLaboListComposite.this.addMessage(result.resultCurrentQuantity + " r\u00e9sultats affich\u00e9s sur " + result.resultTotalQuantity);
                                GetLaboListComposite.this.addMessage("D'autres occurrences non affich\u00e9es sont disponibles... ");
                                GetLaboListComposite.this.addMessage("R\u00e9duisez votre plage de date pour voir tous les r\u00e9sultats.");
                            } else {
                                GetLaboListComposite.this.clearMessage("default");
                            }
                        } else {
                            list = Collections.emptyList();
                            GetLaboListComposite.this.clearMessage("default");
                        }
                        GetLaboListComposite.this.disposeTableColumns();
                        GetLaboListComposite.this.createTableColumns();
                        SearchItem[] items = new SearchItem[list.size()];
                        int i = 0;
                        while (i < items.length) {
                            items[i] = GetLaboListComposite.this.newSearchItem(list.get(i));
                            ++i;
                        }
                        GetLaboListComposite.this.loadSearchListInTable(items);
                        GetLaboListComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                }
            }
        });
    }

    public static List<LaboReportHeaderFlat> orderSearchResults(QueryContinuationResult result) {
        ArrayList<LaboReportHeaderFlat> list = result == null || result.laboResults == null ? new ArrayList<LaboReportHeaderFlat>() : LaboReportHeaderFlat.from((List)result.laboResults);
        Collections.sort(list, new Comparator<LaboReportHeaderFlat>(){

            @Override
            public int compare(LaboReportHeaderFlat o1, LaboReportHeaderFlat o2) {
                return -o1.laboReportHeader.specimenCollectionStartDatetime.compareTo(o2.laboReportHeader.specimenCollectionStartDatetime);
            }
        });
        return list;
    }

    protected void createTableColumns() {
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(true);
        this.tableColumns = new ArrayList();
        if (Application.get().getGlobalInstances().inDebugMode()) {
            this.tableColumns.add(new SearchColumn<LaboReportHeaderFlat>((Table)this.tblSearch, "#"){

                public String getText(LaboReportHeaderFlat e) {
                    return StringUtils.defaultString((String)e.laboResultId.extension);
                }
            });
        }
        this.tableColumns.add(new SearchColumn<LaboReportHeaderFlat>((Table)this.tblSearch, "Date de pr\u00e9l\u00e8vement"){

            public String getText(LaboReportHeaderFlat e) {
                return DateUtil.nonThreadSafeFormat((Long)e.laboReportHeader.specimenCollectionStartDatetime, (String)"yyyy-MM-dd HH:mm:ss");
            }
        });
        this.tableColumns.add(new SearchColumn<LaboReportHeaderFlat>((Table)this.tblSearch, "Mots-cl\u00e9s"){

            public String getText(LaboReportHeaderFlat e) {
                if (e.laboReportHeader.title == null) {
                    return "";
                }
                List keywords = LaboReportHeader.getKeywords((String)e.laboReportHeader.title);
                return new JoinList("; ", (Collection)keywords).toString();
            }
        });
        this.tableColumns.add(new SearchColumn<LaboReportHeaderFlat>((Table)this.tblSearch, "Statut"){

            public String getText(LaboReportHeaderFlat e) {
                if (e.laboReportHeader.reportType != null && "SURGP".equals(e.laboReportHeader.reportType.code)) {
                    return "s/o";
                }
                if ("completed".equals(e.laboResultStatus.code)) {
                    return "Final";
                }
                if ("active".equals(e.laboResultStatus.code)) {
                    return "Partiel";
                }
                return "s/o";
            }
        });
        this.tableColumns.add(new SearchColumn<LaboReportHeaderFlat>((Table)this.tblSearch, "Libell\u00e9"){

            public String getText(LaboReportHeaderFlat e) {
                return StringUtils.defaultString((String)e.laboReportHeader.reportType.text);
            }
        });
        this.tableColumns.add(new SearchColumn<LaboReportHeaderFlat>((Table)this.tblSearch, "Prescripteur"){

            public String getText(LaboReportHeaderFlat e) {
                if (e.laboRequest.author != null) {
                    return StringUtils.join((String)", ", (Object[])new Object[]{e.laboRequest.author.getFirstName(), e.laboRequest.author.getLastName()});
                }
                return "";
            }
        });
        this.tableColumns.add(new SearchColumn<LaboReportHeaderFlat>((Table)this.tblSearch, "Anormal?"){

            public String getText(LaboReportHeaderFlat e) {
                return e.laboReportHeader.anormalFlag ? "anormal" : "non d\u00e9fini";
            }
        });
    }

    protected void processSelection(SearchItem item) {
        if (this.getReferenceControl() != null && this.getReferenceControl() instanceof IReferenceControl) {
            return;
        }
        if (item != null && item.getData() instanceof LaboReportHeaderFlat) {
            LaboReportHeaderFlat labo = (LaboReportHeaderFlat)item.getData();
            IPatient patient = this.listController.getPatient();
            EditorInput input = new EditorInput((IDataObject)LaboReportHeaderImageElement.getPatientImage(patient, labo));
            BaseEditor.openEditorSafePlain((IEditorInput)input, (String)LaboAndScanSingleViewEditor.class.getName());
        }
    }

    protected void showContextMenu(Control parent) {
    }

    public void reset() {
        super.reset();
        this.txtPatient.setDataObject(null);
        this.txtDateFrom.setDate((IPartialDate)this.listController.getStart());
        this.txtDateTo.setDate((IPartialDate)this.listController.getEnd());
    }

    protected void createNew() {
        throw new UnsupportedOperationException();
    }

    public void setPatient(IPatient patient) {
        this.txtPatient.callback((Object)patient);
        this.listController.setPatient(patient);
        this.clearMessage();
        this.loadSearchListInTable(new SearchItem[0]);
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }
}

