/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan;

import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.scan.TransformationException;
import ca.infodata.ofys.ui.scan.scan.ImageRotation;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class ImageUtils {
    private static final Logger logger = Logger.getLogger(ImageUtils.class.getName());
    public static final int IMAGE_JPEG = 0;
    public static final int IMAGE_PNG = 1;
    static Comparator<BitPixels> compareBits = new Comparator<BitPixels>(){

        @Override
        public int compare(BitPixels o1, BitPixels o2) {
            return o1.highPix.compareTo(o2.highPix);
        }
    };
    static List<BitPixels> pixels1Bits = new ArrayList<BitPixels>();
    static List<BitPixels> pixels2Bits;
    static List<BitPixels> pixels4Bits;
    static List<BitPixels> pixels8Bits;

    static {
        pixels1Bits.add(new BitPixels(0xE4E4E4, 0));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        pixels1Bits.add(new BitPixels(0xE4E4E5, 0xFFFFFF));
        Collections.sort(pixels1Bits, compareBits);
        pixels2Bits = new ArrayList<BitPixels>();
        pixels2Bits.add(new BitPixels(0xDDDDDC, 0));
        pixels2Bits.add(new BitPixels(0xDDDDDD, 0x5C5C5C));
        pixels2Bits.add(new BitPixels(0xDDDDDD, 0x5C5C5C));
        pixels2Bits.add(new BitPixels(0xDDDDDD, 0x5C5C5C));
        pixels2Bits.add(new BitPixels(0xDDDDDD, 0x5C5C5C));
        pixels2Bits.add(new BitPixels(0xE4E4E4, 0x999999));
        pixels2Bits.add(new BitPixels(0xE4E4E4, 0x999999));
        pixels2Bits.add(new BitPixels(0xE4E4E4, 0x999999));
        pixels2Bits.add(new BitPixels(0xE4E4E4, 0x999999));
        pixels2Bits.add(new BitPixels(0xEEEEEE, 0xFFFFFF));
        pixels2Bits.add(new BitPixels(0xEEEEEE, 0xFFFFFF));
        pixels2Bits.add(new BitPixels(0xEEEEEE, 0xFFFFFF));
        pixels2Bits.add(new BitPixels(0xEEEEEE, 0xFFFFFF));
        pixels2Bits.add(new BitPixels(0xEEEEEE, 0xFFFFFF));
        pixels2Bits.add(new BitPixels(0xEEEEEE, 0xFFFFFF));
        pixels2Bits.add(new BitPixels(0xEEEEEE, 0xFFFFFF));
        Collections.sort(pixels2Bits, compareBits);
        pixels4Bits = new ArrayList<BitPixels>();
        pixels4Bits.add(new BitPixels(0x111111, 0));
        pixels4Bits.add(new BitPixels(0x222222, 0x111111));
        pixels4Bits.add(new BitPixels(0x333333, 0x222222));
        pixels4Bits.add(new BitPixels(0x444444, 0x333333));
        pixels4Bits.add(new BitPixels(0x555555, 0x444444));
        pixels4Bits.add(new BitPixels(0x666666, 0x555555));
        pixels4Bits.add(new BitPixels(0x777777, 0x666666));
        pixels4Bits.add(new BitPixels(0x888888, 0x777777));
        pixels4Bits.add(new BitPixels(0x999999, 0x888888));
        pixels4Bits.add(new BitPixels(0xAAAAAA, 0x999999));
        pixels4Bits.add(new BitPixels(0xBBBBBB, 0xAAAAAA));
        pixels4Bits.add(new BitPixels(0xCCCCCC, 0xBBBBBB));
        pixels4Bits.add(new BitPixels(0xDDDDDD, 0xCCCCCC));
        pixels4Bits.add(new BitPixels(0xEEEEEE, 0xDDDDDD));
        pixels4Bits.add(new BitPixels(16000000, 0xEEEEEE));
        pixels4Bits.add(new BitPixels(0xFFFFFF, 0xFFFFFF));
        Collections.sort(pixels4Bits, compareBits);
        pixels8Bits = new ArrayList<BitPixels>();
        pixels8Bits.add(new BitPixels(65793, 0));
        pixels8Bits.add(new BitPixels(131586, 65793));
        pixels8Bits.add(new BitPixels(197379, 131586));
        pixels8Bits.add(new BitPixels(263172, 197379));
        pixels8Bits.add(new BitPixels(328965, 263172));
        pixels8Bits.add(new BitPixels(394758, 328965));
        pixels8Bits.add(new BitPixels(460551, 394758));
        pixels8Bits.add(new BitPixels(526344, 460551));
        pixels8Bits.add(new BitPixels(592137, 526344));
        pixels8Bits.add(new BitPixels(657930, 592137));
        pixels8Bits.add(new BitPixels(723723, 657930));
        pixels8Bits.add(new BitPixels(789516, 723723));
        pixels8Bits.add(new BitPixels(855309, 789516));
        pixels8Bits.add(new BitPixels(921102, 855309));
        pixels8Bits.add(new BitPixels(986895, 921102));
        pixels8Bits.add(new BitPixels(0x101010, 986895));
        pixels8Bits.add(new BitPixels(0x111111, 0x101010));
        pixels8Bits.add(new BitPixels(0x121212, 0x111111));
        pixels8Bits.add(new BitPixels(0x131313, 0x121212));
        pixels8Bits.add(new BitPixels(0x141414, 0x131313));
        pixels8Bits.add(new BitPixels(0x151515, 0x141414));
        pixels8Bits.add(new BitPixels(0x161616, 0x151515));
        pixels8Bits.add(new BitPixels(0x171717, 0x161616));
        pixels8Bits.add(new BitPixels(0x181818, 0x171717));
        pixels8Bits.add(new BitPixels(0x191919, 0x181818));
        pixels8Bits.add(new BitPixels(0x1A1A1A, 0x191919));
        pixels8Bits.add(new BitPixels(0x1B1B1B, 0x1A1A1A));
        pixels8Bits.add(new BitPixels(0x1C1C1C, 0x1B1B1B));
        pixels8Bits.add(new BitPixels(0x1D1D1D, 0x1C1C1C));
        pixels8Bits.add(new BitPixels(0x1E1E1E, 0x1D1D1D));
        pixels8Bits.add(new BitPixels(0x1F1F1F, 0x1E1E1E));
        pixels8Bits.add(new BitPixels(0x202020, 0x1F1F1F));
        pixels8Bits.add(new BitPixels(0x212121, 0x202020));
        pixels8Bits.add(new BitPixels(0x222222, 0x212121));
        pixels8Bits.add(new BitPixels(0x232323, 0x222222));
        pixels8Bits.add(new BitPixels(0x242424, 0x232323));
        pixels8Bits.add(new BitPixels(0x252525, 0x242424));
        pixels8Bits.add(new BitPixels(0x262626, 0x252525));
        pixels8Bits.add(new BitPixels(0x272727, 0x262626));
        pixels8Bits.add(new BitPixels(0x282828, 0x272727));
        pixels8Bits.add(new BitPixels(0x292929, 0x282828));
        pixels8Bits.add(new BitPixels(0x2A2A2A, 0x292929));
        pixels8Bits.add(new BitPixels(0x2B2B2B, 0x2A2A2A));
        pixels8Bits.add(new BitPixels(0x2C2C2C, 0x2B2B2B));
        pixels8Bits.add(new BitPixels(0x2D2D2D, 0x2C2C2C));
        pixels8Bits.add(new BitPixels(0x2E2E2E, 0x2D2D2D));
        pixels8Bits.add(new BitPixels(0x2F2F2F, 0x2E2E2E));
        pixels8Bits.add(new BitPixels(0x303030, 0x2F2F2F));
        pixels8Bits.add(new BitPixels(0x313131, 0x303030));
        pixels8Bits.add(new BitPixels(0x323232, 0x313131));
        pixels8Bits.add(new BitPixels(0x333333, 0x323232));
        pixels8Bits.add(new BitPixels(0x343434, 0x333333));
        pixels8Bits.add(new BitPixels(0x353535, 0x343434));
        pixels8Bits.add(new BitPixels(0x363636, 0x353535));
        pixels8Bits.add(new BitPixels(0x373737, 0x363636));
        pixels8Bits.add(new BitPixels(0x383838, 0x373737));
        pixels8Bits.add(new BitPixels(0x393939, 0x383838));
        pixels8Bits.add(new BitPixels(0x3A3A3A, 0x393939));
        pixels8Bits.add(new BitPixels(0x3B3B3B, 0x3A3A3A));
        pixels8Bits.add(new BitPixels(0x3C3C3C, 0x3B3B3B));
        pixels8Bits.add(new BitPixels(0x3D3D3D, 0x3C3C3C));
        pixels8Bits.add(new BitPixels(0x3E3E3E, 0x3D3D3D));
        pixels8Bits.add(new BitPixels(0x3F3F3F, 0x3E3E3E));
        pixels8Bits.add(new BitPixels(0x404040, 0x3F3F3F));
        pixels8Bits.add(new BitPixels(0x414141, 0x404040));
        pixels8Bits.add(new BitPixels(0x424242, 0x414141));
        pixels8Bits.add(new BitPixels(0x434343, 0x424242));
        pixels8Bits.add(new BitPixels(0x444444, 0x434343));
        pixels8Bits.add(new BitPixels(0x454545, 0x444444));
        pixels8Bits.add(new BitPixels(0x464646, 0x454545));
        pixels8Bits.add(new BitPixels(0x474747, 0x464646));
        pixels8Bits.add(new BitPixels(0x484848, 0x474747));
        pixels8Bits.add(new BitPixels(0x494949, 0x484848));
        pixels8Bits.add(new BitPixels(0x4A4A4A, 0x494949));
        pixels8Bits.add(new BitPixels(0x4B4B4B, 0x4A4A4A));
        pixels8Bits.add(new BitPixels(0x4C4C4C, 0x4B4B4B));
        pixels8Bits.add(new BitPixels(0x4D4D4D, 0x4C4C4C));
        pixels8Bits.add(new BitPixels(0x4E4E4E, 0x4D4D4D));
        pixels8Bits.add(new BitPixels(0x4F4F4F, 0x4E4E4E));
        pixels8Bits.add(new BitPixels(0x505050, 0x4F4F4F));
        pixels8Bits.add(new BitPixels(0x515151, 0x505050));
        pixels8Bits.add(new BitPixels(0x525252, 0x515151));
        pixels8Bits.add(new BitPixels(0x535353, 0x525252));
        pixels8Bits.add(new BitPixels(0x545454, 0x535353));
        pixels8Bits.add(new BitPixels(0x555555, 0x545454));
        pixels8Bits.add(new BitPixels(0x565656, 0x555555));
        pixels8Bits.add(new BitPixels(0x575757, 0x565656));
        pixels8Bits.add(new BitPixels(0x585858, 0x575757));
        pixels8Bits.add(new BitPixels(0x595959, 0x585858));
        pixels8Bits.add(new BitPixels(0x5A5A5A, 0x595959));
        pixels8Bits.add(new BitPixels(0x5B5B5B, 0x5A5A5A));
        pixels8Bits.add(new BitPixels(0x5C5C5C, 0x5B5B5B));
        pixels8Bits.add(new BitPixels(0x5D5D5D, 0x5C5C5C));
        pixels8Bits.add(new BitPixels(0x5E5E5E, 0x5D5D5D));
        pixels8Bits.add(new BitPixels(0x5F5F5F, 0x5E5E5E));
        pixels8Bits.add(new BitPixels(0x606060, 0x5F5F5F));
        pixels8Bits.add(new BitPixels(0x616161, 0x606060));
        pixels8Bits.add(new BitPixels(0x626262, 0x616161));
        pixels8Bits.add(new BitPixels(0x636363, 0x626262));
        pixels8Bits.add(new BitPixels(0x646464, 0x636363));
        pixels8Bits.add(new BitPixels(0x656565, 0x646464));
        pixels8Bits.add(new BitPixels(0x666666, 0x656565));
        pixels8Bits.add(new BitPixels(0x676767, 0x666666));
        pixels8Bits.add(new BitPixels(0x686868, 0x676767));
        pixels8Bits.add(new BitPixels(0x696969, 0x686868));
        pixels8Bits.add(new BitPixels(0x6A6A6A, 0x696969));
        pixels8Bits.add(new BitPixels(0x6B6B6B, 0x6A6A6A));
        pixels8Bits.add(new BitPixels(0x6C6C6C, 0x6B6B6B));
        pixels8Bits.add(new BitPixels(0x6D6D6D, 0x6C6C6C));
        pixels8Bits.add(new BitPixels(0x6E6E6E, 0x6D6D6D));
        pixels8Bits.add(new BitPixels(0x6F6F6F, 0x6E6E6E));
        pixels8Bits.add(new BitPixels(0x707070, 0x6F6F6F));
        pixels8Bits.add(new BitPixels(0x717171, 0x707070));
        pixels8Bits.add(new BitPixels(0x727272, 0x717171));
        pixels8Bits.add(new BitPixels(0x737373, 0x727272));
        pixels8Bits.add(new BitPixels(0x747474, 0x737373));
        pixels8Bits.add(new BitPixels(0x757575, 0x747474));
        pixels8Bits.add(new BitPixels(0x767676, 0x757575));
        pixels8Bits.add(new BitPixels(0x777777, 0x767676));
        pixels8Bits.add(new BitPixels(0x787878, 0x777777));
        pixels8Bits.add(new BitPixels(0x797979, 0x787878));
        pixels8Bits.add(new BitPixels(0x7A7A7A, 0x797979));
        pixels8Bits.add(new BitPixels(0x7B7B7B, 0x7A7A7A));
        pixels8Bits.add(new BitPixels(0x7C7C7C, 0x7B7B7B));
        pixels8Bits.add(new BitPixels(0x7D7D7D, 0x7C7C7C));
        pixels8Bits.add(new BitPixels(0x7E7E7E, 0x7D7D7D));
        pixels8Bits.add(new BitPixels(0x7F7F7F, 0x7E7E7E));
        pixels8Bits.add(new BitPixels(0x808080, 0x7F7F7F));
        pixels8Bits.add(new BitPixels(0x818181, 0x808080));
        pixels8Bits.add(new BitPixels(0x828282, 0x818181));
        pixels8Bits.add(new BitPixels(0x838383, 0x828282));
        pixels8Bits.add(new BitPixels(0x848484, 0x838383));
        pixels8Bits.add(new BitPixels(0x858585, 0x848484));
        pixels8Bits.add(new BitPixels(0x868686, 0x858585));
        pixels8Bits.add(new BitPixels(0x878787, 0x868686));
        pixels8Bits.add(new BitPixels(0x888888, 0x878787));
        pixels8Bits.add(new BitPixels(0x898989, 0x888888));
        pixels8Bits.add(new BitPixels(0x8A8A8A, 0x898989));
        pixels8Bits.add(new BitPixels(0x8B8B8B, 0x8A8A8A));
        pixels8Bits.add(new BitPixels(0x8C8C8C, 0x8B8B8B));
        pixels8Bits.add(new BitPixels(0x8D8D8D, 0x8C8C8C));
        pixels8Bits.add(new BitPixels(0x8E8E8E, 0x8D8D8D));
        pixels8Bits.add(new BitPixels(0x8F8F8F, 0x8E8E8E));
        pixels8Bits.add(new BitPixels(0x909090, 0x8F8F8F));
        pixels8Bits.add(new BitPixels(0x919191, 0x909090));
        pixels8Bits.add(new BitPixels(0x929292, 0x919191));
        pixels8Bits.add(new BitPixels(0x939393, 0x929292));
        pixels8Bits.add(new BitPixels(0x949494, 0x939393));
        pixels8Bits.add(new BitPixels(0x959595, 0x949494));
        pixels8Bits.add(new BitPixels(0x969696, 0x959595));
        pixels8Bits.add(new BitPixels(0x979797, 0x969696));
        pixels8Bits.add(new BitPixels(0x989898, 0x979797));
        pixels8Bits.add(new BitPixels(0x999999, 0x989898));
        pixels8Bits.add(new BitPixels(0x9A9A9A, 0x999999));
        pixels8Bits.add(new BitPixels(0x9B9B9B, 0x9A9A9A));
        pixels8Bits.add(new BitPixels(0x9C9C9C, 0x9B9B9B));
        pixels8Bits.add(new BitPixels(0x9D9D9D, 0x9C9C9C));
        pixels8Bits.add(new BitPixels(0x9E9E9E, 0x9D9D9D));
        pixels8Bits.add(new BitPixels(0x9F9F9F, 0x9E9E9E));
        pixels8Bits.add(new BitPixels(0xA0A0A0, 0x9F9F9F));
        pixels8Bits.add(new BitPixels(0xA1A1A1, 0xA0A0A0));
        pixels8Bits.add(new BitPixels(0xA2A2A2, 0xA1A1A1));
        pixels8Bits.add(new BitPixels(0xA3A3A3, 0xA2A2A2));
        pixels8Bits.add(new BitPixels(0xA4A4A4, 0xA3A3A3));
        pixels8Bits.add(new BitPixels(0xA5A5A5, 0xA4A4A4));
        pixels8Bits.add(new BitPixels(0xA6A6A6, 0xA5A5A5));
        pixels8Bits.add(new BitPixels(0xA7A7A7, 0xA6A6A6));
        pixels8Bits.add(new BitPixels(0xA8A8A8, 0xA7A7A7));
        pixels8Bits.add(new BitPixels(0xA9A9A9, 0xA8A8A8));
        pixels8Bits.add(new BitPixels(0xAAAAAA, 0xA9A9A9));
        pixels8Bits.add(new BitPixels(0xABABAB, 0xAAAAAA));
        pixels8Bits.add(new BitPixels(0xACACAC, 0xABABAB));
        pixels8Bits.add(new BitPixels(0xADADAD, 0xACACAC));
        pixels8Bits.add(new BitPixels(0xAEAEAE, 0xADADAD));
        pixels8Bits.add(new BitPixels(0xAFAFAF, 0xAEAEAE));
        pixels8Bits.add(new BitPixels(0xB0B0B0, 0xAFAFAF));
        pixels8Bits.add(new BitPixels(0xB1B1B1, 0xB0B0B0));
        pixels8Bits.add(new BitPixels(0xB2B2B2, 0xB1B1B1));
        pixels8Bits.add(new BitPixels(0xB3B3B3, 0xB2B2B2));
        pixels8Bits.add(new BitPixels(0xB4B4B4, 0xB3B3B3));
        pixels8Bits.add(new BitPixels(0xB5B5B5, 0xB4B4B4));
        pixels8Bits.add(new BitPixels(0xB6B6B6, 0xB5B5B5));
        pixels8Bits.add(new BitPixels(0xB7B7B7, 0xB6B6B6));
        pixels8Bits.add(new BitPixels(0xB8B8B8, 0xB7B7B7));
        pixels8Bits.add(new BitPixels(0xB9B9B9, 0xB8B8B8));
        pixels8Bits.add(new BitPixels(0xBABABA, 0xB9B9B9));
        pixels8Bits.add(new BitPixels(0xBBBBBB, 0xBABABA));
        pixels8Bits.add(new BitPixels(0xBCBCBC, 0xBBBBBB));
        pixels8Bits.add(new BitPixels(0xBDBDBD, 0xBCBCBC));
        pixels8Bits.add(new BitPixels(0xBEBEBE, 0xBDBDBD));
        pixels8Bits.add(new BitPixels(0xBFBFBF, 0xBEBEBE));
        pixels8Bits.add(new BitPixels(0xC0C0C0, 0xBFBFBF));
        pixels8Bits.add(new BitPixels(0xC1C1C1, 0xC0C0C0));
        pixels8Bits.add(new BitPixels(0xC2C2C2, 0xC1C1C1));
        pixels8Bits.add(new BitPixels(0xC3C3C3, 0xC2C2C2));
        pixels8Bits.add(new BitPixels(0xC4C4C4, 0xC3C3C3));
        pixels8Bits.add(new BitPixels(0xC5C5C5, 0xC4C4C4));
        pixels8Bits.add(new BitPixels(0xC6C6C6, 0xC5C5C5));
        pixels8Bits.add(new BitPixels(0xC7C7C7, 0xC6C6C6));
        pixels8Bits.add(new BitPixels(0xC8C8C8, 0xC7C7C7));
        pixels8Bits.add(new BitPixels(0xC9C9C9, 0xC8C8C8));
        pixels8Bits.add(new BitPixels(0xCACACA, 0xC9C9C9));
        pixels8Bits.add(new BitPixels(0xCBCBCB, 0xCACACA));
        pixels8Bits.add(new BitPixels(0xCCCCCC, 0xCBCBCB));
        pixels8Bits.add(new BitPixels(0xCDCDCD, 0xCCCCCC));
        pixels8Bits.add(new BitPixels(0xCECECE, 0xCDCDCD));
        pixels8Bits.add(new BitPixels(0xCFCFCF, 0xCECECE));
        pixels8Bits.add(new BitPixels(0xD0D0D0, 0xCFCFCF));
        pixels8Bits.add(new BitPixels(0xD1D1D1, 0xD0D0D0));
        pixels8Bits.add(new BitPixels(0xD2D2D2, 0xD1D1D1));
        pixels8Bits.add(new BitPixels(0xD3D3D3, 0xD2D2D2));
        pixels8Bits.add(new BitPixels(0xD4D4D4, 0xD3D3D3));
        pixels8Bits.add(new BitPixels(0xD5D5D5, 0xD4D4D4));
        pixels8Bits.add(new BitPixels(0xD6D6D6, 0xD5D5D5));
        pixels8Bits.add(new BitPixels(0xD7D7D7, 0xD6D6D6));
        pixels8Bits.add(new BitPixels(0xD8D8D8, 0xD7D7D7));
        pixels8Bits.add(new BitPixels(0xD9D9D9, 0xD8D8D8));
        pixels8Bits.add(new BitPixels(0xDADADA, 0xD9D9D9));
        pixels8Bits.add(new BitPixels(0xDBDBDB, 0xDADADA));
        pixels8Bits.add(new BitPixels(0xDCDCDC, 0xDBDBDB));
        pixels8Bits.add(new BitPixels(0xDDDDDD, 0xDCDCDC));
        pixels8Bits.add(new BitPixels(0xDEDEDE, 0xDDDDDD));
        pixels8Bits.add(new BitPixels(0xDFDFDF, 0xDEDEDE));
        pixels8Bits.add(new BitPixels(0xE0E0E0, 0xDFDFDF));
        pixels8Bits.add(new BitPixels(0xE1E1E1, 0xE0E0E0));
        pixels8Bits.add(new BitPixels(0xE2E2E2, 0xE1E1E1));
        pixels8Bits.add(new BitPixels(0xE3E3E3, 0xE2E2E2));
        pixels8Bits.add(new BitPixels(0xE4E4E4, 0xE3E3E3));
        pixels8Bits.add(new BitPixels(0xE5E5E5, 0xE4E4E4));
        pixels8Bits.add(new BitPixels(0xE6E6E6, 0xE5E5E5));
        pixels8Bits.add(new BitPixels(0xE7E7E7, 0xE6E6E6));
        pixels8Bits.add(new BitPixels(0xE8E8E8, 0xE7E7E7));
        pixels8Bits.add(new BitPixels(0xE9E9E9, 0xE8E8E8));
        pixels8Bits.add(new BitPixels(0xEAEAEA, 0xE9E9E9));
        pixels8Bits.add(new BitPixels(0xEBEBEB, 0xEAEAEA));
        pixels8Bits.add(new BitPixels(0xECECEC, 0xEBEBEB));
        pixels8Bits.add(new BitPixels(0xEDEDED, 0xECECEC));
        pixels8Bits.add(new BitPixels(0xEEEEEE, 0xEDEDED));
        pixels8Bits.add(new BitPixels(0xEFEFEF, 0xEEEEEE));
        pixels8Bits.add(new BitPixels(0xF0F0F0, 0xEFEFEF));
        pixels8Bits.add(new BitPixels(0xF1F1F1, 0xF0F0F0));
        pixels8Bits.add(new BitPixels(0xF2F2F2, 0xF1F1F1));
        pixels8Bits.add(new BitPixels(0xF3F3F3, 0xF2F2F2));
        pixels8Bits.add(new BitPixels(0xF4F4F4, 0xF3F3F3));
        pixels8Bits.add(new BitPixels(0xF5F5F5, 0xF4F4F4));
        pixels8Bits.add(new BitPixels(0xF6F6F6, 0xF5F5F5));
        pixels8Bits.add(new BitPixels(0xF7F7F7, 0xF6F6F6));
        pixels8Bits.add(new BitPixels(0xF8F8F8, 0xF7F7F7));
        pixels8Bits.add(new BitPixels(0xF9F9F9, 0xF8F8F8));
        pixels8Bits.add(new BitPixels(0xFAFAFA, 0xF9F9F9));
        pixels8Bits.add(new BitPixels(0xFBFBFB, 0xFAFAFA));
        pixels8Bits.add(new BitPixels(16554043, 0xFBFBFB));
        pixels8Bits.add(new BitPixels(16604043, 0xFFFFFF));
        pixels8Bits.add(new BitPixels(16654043, 0xFFFFFF));
        pixels8Bits.add(new BitPixels(16700000, 0xFFFFFF));
        pixels8Bits.add(new BitPixels(0xFFFFFF, 0xFFFFFF));
        Collections.sort(pixels8Bits, compareBits);
    }

    public static BufferedImage resizeImage(String imgName, int type, int maxWidth, int maxHeight) throws IOException {
        return ImageUtils.resizeImage(ImageIO.read(new File(imgName)), type, maxWidth, maxHeight);
    }

    public static BufferedImage resizeImage(Image image, int type, int maxWidth, int maxHeight) {
        Dimension largestDimension = new Dimension(maxWidth, maxHeight);
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        float aspectRation = (float)imageWidth / (float)imageHeight;
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            if ((float)largestDimension.width / (float)largestDimension.height > aspectRation) {
                largestDimension.width = (int)Math.ceil((float)largestDimension.height * aspectRation);
            } else {
                largestDimension.height = (int)Math.ceil((float)largestDimension.width / aspectRation);
            }
            imageWidth = largestDimension.width;
            imageHeight = largestDimension.height;
        }
        return ImageUtils.createBufferedImage(image, type, imageWidth, imageHeight);
    }

    public static boolean saveImage(BufferedImage image, String toFileName, int type) throws IOException {
        return ImageIO.write((RenderedImage)image, type == 0 ? "jpg" : "png", new File(toFileName));
    }

    public static void saveCompressedImage(BufferedImage image, String toFileName, int type) throws IOException {
        if (type == 1) {
            throw new UnsupportedOperationException("PNG compression not implemented");
        }
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        writer = iter.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(new File(toFileName));
        writer.setOutput(ios);
        JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
        iwparam.setCompressionMode(2);
        iwparam.setCompressionQuality(0.7f);
        writer.write(null, new IIOImage(image, null, null), iwparam);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    public static BufferedImage createBufferedImage(Image image, int type, int w, int h) {
        type = type == 1 && ImageUtils.hasAlpha(image) ? 2 : 1;
        BufferedImage bi = new BufferedImage(w, h, type);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, w, h, null);
        g.dispose();
        return bi;
    }

    public static boolean hasAlpha(Image image) {
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            pg.grabPixels();
            return pg.getColorModel().hasAlpha();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public static ImageData get8BitPaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] colours = new RGB[256];
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (colours[newPixel] == null) {
                            colours[newPixel] = colour;
                            break;
                        }
                        if (colours[newPixel].equals((Object)colour)) break;
                        ++newPixel;
                    }
                    if (newPixel >= 256) {
                        return null;
                    }
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return newImageData;
    }

    private static int getBitPixel(List<BitPixels> pixels, int pixel) {
        int correspondantPixel = 0;
        int pos = Collections.binarySearch(pixels, new BitPixels(pixel, 0), compareBits);
        if (pos >= 0) {
            correspondantPixel = pixels.get((int)pos).corrPix;
        } else {
            int i = -pos - 1 == pixels.size() ? -pos - 2 : -pos - 1;
            correspondantPixel = pixels.get((int)i).corrPix;
        }
        return correspondantPixel;
    }

    public static ImageData getXBitPaletteImageData(ImageData imageData, int bits, int luminosity) {
        List<BitPixels> pixelsActif;
        RGB[] colours;
        switch (bits) {
            case 1: {
                bits = 4;
                int nombreDeCol = 16;
                colours = new RGB[nombreDeCol];
                pixelsActif = pixels1Bits;
                break;
            }
            case 2: {
                bits = 4;
                int nombreDeCol = 16;
                colours = new RGB[nombreDeCol];
                pixelsActif = pixels2Bits;
                break;
            }
            case 4: {
                int nombreDeCol = 16;
                colours = new RGB[nombreDeCol];
                pixelsActif = pixels4Bits;
                break;
            }
            case 8: {
                int nombreDeCol = 256;
                colours = new RGB[nombreDeCol];
                pixelsActif = pixels8Bits;
                break;
            }
            default: {
                return imageData;
            }
        }
        int indexColor = 0;
        for (BitPixels p : pixelsActif) {
            colours[indexColor] = ResourceGetter.transfertIntegerToRGB((int)p.corrPix);
            ++indexColor;
        }
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, bits, newPaletteData);
        int newPixel = 0;
        PaletteData palette = imageData.palette;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                RGB rgb = palette.getRGB(pixel);
                pixel = ResourceGetter.transfertColorToInteger((RGB)rgb) - (luminosity - 8000000);
                newPixel = ImageUtils.getBitPixel(pixelsActif, pixel);
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return newImageData;
    }

    public static ImageData setImageDepth(ImageData source, int ppp, int depth, int luminosity) throws TransformationException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        int[] depths = nArray;
        if (Arrays.binarySearch(depths, 0, depths.length, depth) < 0) {
            throw new IllegalArgumentException("depth is invalid " + depth);
        }
        ImageData newImageData = null;
        int prevWidth = source.width;
        System.out.println("Pr\ufffd modif: w=" + source.width + ", h=" + source.height);
        newImageData = ImageUtils.getScaledForPPP(source, ppp);
        if (newImageData.depth > 8 && depth == 0) {
            System.out.println(">8 bits... ");
            if (depth != 0) {
                newImageData = ImageUtils.get8BitPaletteImageData(newImageData);
            }
            if (newImageData == null) {
                throw new TransformationException("Invalid depth");
            }
            if (newImageData.depth != depth || newImageData.width != prevWidth) {
                newImageData = ImageUtils.getXBitPaletteImageData(newImageData, depth, luminosity);
            }
            if (newImageData != null) {
                System.out.println("Post modif: w=" + newImageData.width + ", h=" + newImageData.height);
            }
        }
        return newImageData;
    }

    public static ImageData getScaledForPPP(ImageData imageData, float ppp) {
        float w = imageData.width;
        float ratio = 1.0f;
        int presumedPPP = -1;
        if (w > 2400.0f) {
            presumedPPP = 300;
            if (ppp < 300.0f) {
                ratio = 300.0f / ppp;
            }
        } else if (w > 1600.0f) {
            presumedPPP = 200;
            if (ppp < 300.0f) {
                ratio = 200.0f / ppp;
            }
        } else if (w > 1200.0f) {
            presumedPPP = 150;
            if (ppp < 150.0f) {
                ratio = 150.0f / ppp;
            }
        } else if (w > 800.0f) {
            presumedPPP = 100;
            if (ppp < 100.0f) {
                ratio = 100.0f / ppp;
            }
        }
        System.out.println("ratio is " + ratio + " for presumed ppp " + presumedPPP + " and asked ppp " + ppp);
        System.out.println("PPI pour 8.5X11: w=" + (double)imageData.width / 8.48 + ", h=" + (double)imageData.height / 10.96);
        if (ratio != 1.0f) {
            imageData = imageData.scaledTo((int)((float)imageData.width / ratio), (int)((float)imageData.height / ratio));
        }
        return imageData;
    }

    public static ImageData rotateImage(ImageData imageData, ImageRotation rotation) {
        float[] matrix;
        if (imageData == null) {
            throw new NullPointerException("imageData");
        }
        if (rotation == ImageRotation.R_0) {
            return imageData;
        }
        if (rotation == ImageRotation.R_90) {
            matrix = new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        } else if (rotation == ImageRotation.R_180) {
            matrix = new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
        } else if (rotation == ImageRotation.R_270) {
            matrix = new float[]{0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f};
        } else {
            throw new IllegalArgumentException("unsupported roration value " + (Object)((Object)rotation));
        }
        Transform transform = null;
        GC gc = null;
        org.eclipse.swt.graphics.Image src = null;
        org.eclipse.swt.graphics.Image dest = null;
        ImageData imageData2 = null;
        try {
            try {
                Display display = Display.getDefault();
                transform = new Transform((Device)display, matrix);
                src = new org.eclipse.swt.graphics.Image((Device)display, imageData);
                dest = rotation == ImageRotation.R_90 || rotation == ImageRotation.R_270 ? new org.eclipse.swt.graphics.Image((Device)display, imageData.height, imageData.width) : new org.eclipse.swt.graphics.Image((Device)display, imageData.width, imageData.height);
                gc = new GC((Drawable)dest);
                gc.setAdvanced(true);
                gc.setTransform(transform);
                if (rotation == ImageRotation.R_90) {
                    gc.drawImage(src, -1 * imageData.width, 0);
                } else if (rotation == ImageRotation.R_180) {
                    gc.drawImage(src, -1 * imageData.width, -1 * imageData.height);
                } else if (rotation == ImageRotation.R_270) {
                    gc.drawImage(src, 0, -1 * imageData.height);
                }
                imageData2 = dest.getImageData();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to rotate image. rotation=" + (Object)((Object)rotation), e);
                if (dest != null) {
                    dest.dispose();
                }
                if (src != null) {
                    src.dispose();
                }
                if (transform != null) {
                    transform.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
                return null;
            }
        }
        finally {
            if (dest != null) {
                dest.dispose();
            }
            if (src != null) {
                src.dispose();
            }
            if (transform != null) {
                transform.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
        }
        return imageData2;
    }

    private static class BitPixels {
        Integer highPix;
        Integer corrPix;

        public BitPixels(int h, int c) {
            this.highPix = new Integer(h);
            this.corrPix = new Integer(c);
        }
    }
}

