/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences.patientlabel;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.GenericReportAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseGenericReport;
import ca.infodata.ofys.data.middle.dataobjects.XGenericReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.preferences.patientlabel.BasePatientLabelEditor;
import ca.infodata.util1.date.LocaleProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class PatientLabelEditor
extends BasePatientLabelEditor {
    @Override
    protected void setColunmLayoutData() {
        this.lastColunm = this.txtColunmOne;
        this.txtColunmThree.setVisible(false);
        this.txtColunmTwo.setVisible(false);
        int horzSize = ((int)((double)this.getGenericReport().getHorizontalSize().intValue() * 1.25) + 5) / this.getGenericReport().getNbColumns();
        int verSize = (int)((double)this.getGenericReport().getVerticalSize() * 1.25);
        switch (this.getGenericReport().getNbColumns()) {
            case 3: {
                this.txtColunmThree.setVisible(true);
                this.txtColunmTwo.setVisible(true);
                break;
            }
            case 2: {
                this.txtColunmTwo.setVisible(true);
            }
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.varInfoComp, 20, 128);
        data.left = new FormAttachment((Control)this.varInfoComp, 20);
        data.width = horzSize;
        data.height = verSize;
        this.txtColunmOne.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.varInfoComp, 20, 128);
        data.left = new FormAttachment(this.txtColunmOne.getControl(), 0);
        data.width = horzSize;
        data.height = verSize;
        this.txtColunmTwo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.varInfoComp, 20, 128);
        data.left = new FormAttachment(this.txtColunmTwo.getControl(), 0);
        data.width = horzSize;
        data.height = verSize;
        this.txtColunmThree.setLayoutData((Object)data);
        this.txtColunmTwo.getParent().pack();
        this.getCompMain().layout(true, true);
    }

    @Override
    protected void onPaint(PaintEvent e) {
        if (this.getGenericReport() != null) {
            int ptRight = 0;
            switch (this.getGenericReport().getNbColumns()) {
                case 3: {
                    ptRight = this.txtColunmThree.getBounds().width + this.txtColunmThree.getBounds().x;
                    break;
                }
                case 2: {
                    ptRight = this.txtColunmTwo.getBounds().width + this.txtColunmTwo.getBounds().x;
                    break;
                }
                case 1: {
                    ptRight = this.txtColunmOne.getBounds().width + this.txtColunmOne.getBounds().x;
                }
            }
            int xColunmOne = this.txtColunmOne.getBounds().x;
            int yColunmOne = this.txtColunmOne.getBounds().y;
            int heightDroit = this.txtColunmOne.getBounds().height;
            String strHor = this.getGenericReport().getFormatedWith();
            String strVer = this.getGenericReport().getFormatedHeight();
            int hy = yColunmOne - 10;
            int vy1 = hy - 5;
            int vy2 = hy + 5;
            int ty = hy - 20;
            e.gc.drawLine(xColunmOne, hy, ptRight, hy);
            e.gc.drawLine(xColunmOne, vy1, xColunmOne, vy2);
            e.gc.drawLine(ptRight, vy1, ptRight, vy2);
            Point textSize = e.gc.textExtent(strHor);
            e.gc.drawText(strHor, (ptRight + xColunmOne - textSize.x) / 2, ty, true);
            Point textSizeVert = e.gc.textExtent(strVer);
            e.gc.drawLine(ptRight + 10, yColunmOne, ptRight + 10, heightDroit + yColunmOne);
            e.gc.drawLine(ptRight + 5, yColunmOne, ptRight + 15, yColunmOne);
            e.gc.drawLine(ptRight + 5, heightDroit + yColunmOne, ptRight + 15, heightDroit + yColunmOne);
            e.gc.drawText(strVer, ptRight + 13, heightDroit / 2 + yColunmOne - textSizeVert.y, true);
        }
    }

    @Override
    protected void setVarInColumn(String strVar) {
        String str = this.lastColunm.getText();
        int caretPos = this.lastColunm.getCaretPosition();
        this.lastColunm.setText(String.valueOf(str.substring(0, caretPos)) + strVar + str.substring(caretPos));
        this.lastColunm.setFocus();
        this.lastColunm.setSelection(caretPos + strVar.length(), caretPos + strVar.length());
        Event e = new Event();
        e.widget = this.lastColunm.getControl();
        this.lastColunm.notifyListeners(24, e);
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return GenericReportAccessorClient.getInstance();
    }

    public void initDataOverride() {
        if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XBaseGenericReport) {
            XBaseGenericReport baseGenericReport = (XBaseGenericReport)((EditorInput)this.getEditorInput()).getDataObject();
            if (baseGenericReport.getId() == null) {
                XGenericReport genericReport = new XGenericReport();
                genericReport.initialize();
                this.initializeCompleteDataObject((EditableDataObject)genericReport);
            } else {
                try {
                    GenericReportAccessorClient.getInstance().getGenericReport(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), (ICallback)new JobCallback("getGenericReport", (IStatusHandler)DefaultStatusHandler.getInstance()){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PatientLabelEditor.this.initializeCompleteDataObject((EditableDataObject)response.getObj());
                                }
                            });
                        }
                    }, baseGenericReport.getId().intValue());
                }
                catch (Exception e) {
                    Log.severe((String)"Erreur", (Exception)e);
                }
            }
        } else if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XGenericReport) {
            this.initializeCompleteDataObject((EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject());
        }
    }

    public boolean isDataDirty() {
        return this.getGenericReport().isDirty();
    }

    public void setToolBarStatus() {
    }

    public IVariablesReplacer getVariablesReplacerNewInstance() {
        return null;
    }

    public void showDataObject() {
        XGenericReport genericReport = this.getGenericReport();
        this.txtFrench.setRawText(genericReport.getFrench());
        this.txtEnglish.setRawText(genericReport.getEnglish());
        this.txtEspanol.setRawText(genericReport.getSpanish());
        this.cmbCol.select(genericReport.getNbColumns() - 1);
        this.cmbSize.select(genericReport.getSizeListPosition());
        if (!genericReport.isNewOrNewUpdated()) {
            switch (genericReport.getNbColumns()) {
                case 3: {
                    this.txtColunmThree.setText(genericReport.getColumnThree().getContent());
                }
                case 2: {
                    this.txtColunmTwo.setText(genericReport.getColumnTwo().getContent());
                }
                case 1: {
                    this.txtColunmOne.setText(genericReport.getColumnOne().getContent());
                }
            }
        } else {
            switch (genericReport.getNbColumns()) {
                case 3: {
                    this.txtColunmThree.setText("");
                }
                case 2: {
                    this.txtColunmTwo.setText("");
                }
                case 1: {
                    this.txtColunmOne.setText("");
                }
            }
        }
        this.setColunmLayoutData();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/enc-icon16.png");
    }

    public String getEditorTitle() {
        XGenericReport report = this.getGenericReport();
        String title = "null";
        if (report != null) {
            if (report.isNewOrNewUpdated()) {
                title = Messages.getString((String)"NOUVELLE_ETIQUETTE", (String[])new String[0]);
            } else if (LocaleProvider.isFrench()) {
                title = report.getFrench();
            } else if (LocaleProvider.isEnglish()) {
                title = report.getEnglish();
            } else if (LocaleProvider.isSpanish()) {
                title = report.getSpanish();
            }
        }
        return title;
    }
}

