/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.medication.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;

public class NewPrescriptionContentProvider
extends ArrayContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            List list = (List)inputElement;
            if (!Application.get().getGlobalInstances().inDebugMode()) {
                HashSet<Integer> idAnchorsToExlude = new HashSet<Integer>();
                HashSet<XPrescription> prescriptionsToExclude = new HashSet<XPrescription>();
                for (XPrescription p : list) {
                    if (p.getPrevPrescriptionId() == null || p.getStopDate() == null) continue;
                    boolean isReRxStopPrescription = false;
                    for (XPrescription x : list) {
                        if (p.equals((Object)x) || !p.getPrevPrescriptionId().equals(x.getPrevPrescriptionId()) || x.getStopDate() != null) continue;
                        isReRxStopPrescription = true;
                        break;
                    }
                    if (!isReRxStopPrescription) continue;
                    if (p.getIdAnchor() != null) {
                        idAnchorsToExlude.add(p.getIdAnchor());
                        continue;
                    }
                    prescriptionsToExclude.add(p);
                }
                list.removeAll(prescriptionsToExclude);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    XPrescription x = (XPrescription)iterator.next();
                    if (x.getIdAnchor() == null || !idAnchorsToExlude.contains(x.getIdAnchor())) continue;
                    iterator.remove();
                }
            }
            Collections.sort(list, new Comparator<XPrescription>(){

                @Override
                public int compare(XPrescription a0, XPrescription a1) {
                    if (a0.getStopDate() != null && a1.getStopDate() == null) {
                        return 1;
                    }
                    if (a1.getStopDate() != null && a0.getStopDate() == null) {
                        return -1;
                    }
                    if (a0.getStopEncounter() != null && a0.getStopEncounter() == null) {
                        return 1;
                    }
                    if (a1.getStopEncounter() != null && a0.getStopEncounter() == null) {
                        return -1;
                    }
                    if (a0.getId() == a1.getId()) {
                        return 0;
                    }
                    if (a0.getId() == null) {
                        return -1;
                    }
                    if (a1.getId() == null) {
                        return 1;
                    }
                    return a0.getId().compareTo(a1.getId());
                }
            });
            return list.toArray();
        }
        return null;
    }
}

