/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.medication.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.DsqFormatter;
import ca.infodata.ofys.client.modules.encounter.XPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.encounter.medication.editor.PrescriptionByGroupContentProvider;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;

public class InactivePrescriptionByGroupLabelProvider
extends ColumnLabelProvider {
    private static final String _ARRETER_LE_ = Messages.getString((String)"BasePrescriptionSwitchTable._ARRETEE_LE_", (String[])new String[0]);
    private static final Color red = ResourceGetter.getRedWarningColor();

    public String getText(Object element) {
        String text = null;
        if (element instanceof PrescriptionByGroupContentProvider.GroupItem) {
            PrescriptionByGroupContentProvider.GroupItem group = (PrescriptionByGroupContentProvider.GroupItem)element;
            String string = group.xPresription.getStrength() != null ? XPrescriptionFormatter.formatDrugNameWithBrackets((XDrugStrength)group.xPresription.getStrength()) : (text = group.xPresription.getDevice() == null ? "?" : group.xPresription.getDevice().getName());
            if (group.children != null && group.children.size() > 0) {
                XPrescription p = group.children.get((int)0).prescription;
                text = String.valueOf(DsqFormatter.formatDsqPrefix((XPrescription)p)) + text;
            }
            if (group.xPresription.getStopDate() != null) {
                text = String.valueOf(text) + _ARRETER_LE_ + LocalDateFormat.format((LocalDate)group.xPresription.getStopDate(), (String)FormatDateProvider.getFormatDate().toString()) + ")";
            }
        } else if (element instanceof PrescriptionByGroupContentProvider.PrescriptionItem) {
            PrescriptionByGroupContentProvider.PrescriptionItem item = (PrescriptionByGroupContentProvider.PrescriptionItem)element;
            text = XPrescriptionFormatter.formatInactive((XPrescription)item.prescription, (CPrescriptionFormatter.ShowMedFileDetail)CPrescriptionFormatter.ShowMedFileDetail.MAXIMUM);
            text = String.valueOf(DsqFormatter.formatDsqPrefix((XPrescription)item.prescription)) + text;
            if (Application.get().getGlobalInstances().inDebugMode()) {
                text = item.prescription.getIdAnchor() + ", " + item.prescription.getId() + ", " + text;
            }
        }
        return text;
    }

    public Color getBackground(Object element) {
        Color oldColor = super.getBackground(element);
        Color newColor = null;
        if (element instanceof PrescriptionByGroupContentProvider.GroupItem) {
            PrescriptionByGroupContentProvider.GroupItem gi = (PrescriptionByGroupContentProvider.GroupItem)element;
            XPrescription[] list = new XPrescription[gi.children.size()];
            int i = 0;
            for (PrescriptionByGroupContentProvider.PrescriptionItem pi : gi.children) {
                list[i] = pi.prescription;
                ++i;
            }
            newColor = this.getPrescriptionsMaxColor(list);
        } else if (element instanceof PrescriptionByGroupContentProvider.PrescriptionItem) {
            PrescriptionByGroupContentProvider.PrescriptionItem item = (PrescriptionByGroupContentProvider.PrescriptionItem)element;
            newColor = this.getPrescriptionColor(item.prescription);
        }
        if (newColor == null) {
            newColor = oldColor;
        }
        return newColor;
    }

    private Color getPrescriptionsMaxColor(XPrescription ... pres) {
        Color color = null;
        XPrescription[] xPrescriptionArray = pres;
        int n = pres.length;
        int n2 = 0;
        while (n2 < n) {
            XPrescription p = xPrescriptionArray[n2];
            Color nc = this.getPrescriptionColor(p);
            if (red.equals((Object)(color = color == null ? nc : this.maxColor(color, nc)))) break;
            ++n2;
        }
        return color;
    }

    private Color getPrescriptionColor(XPrescription pres) {
        Color color = null;
        if (pres != null) {
            LocalDate date = pres.getPresumedDateToRenvew();
            if (pres.getEndDate() != null && (date == null || pres.getEndDate().before((IPartialDate)date))) {
                date = pres.getEndDate();
            }
            if (date != null && pres.getStopDate() == null && date.beforeOrEquals(LocalDate.today()) && date.plusMonth(24).after((IPartialDate)LocalDate.today())) {
                color = red;
            }
        }
        return color;
    }

    private Color maxColor(Color a, Color b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.equals((Object)red)) {
            return a;
        }
        if (b.equals((Object)red)) {
            return b;
        }
        return null;
    }
}

