/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.user;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.UserAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.encryption.DesEncrypter;
import ca.infodata.util1.encryption.EncryptionException;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseUserControl
extends Composite {
    private PersonMultiEditor parentEditor;
    public static final int STANDARD_TEXT_LIMIT = 100;
    protected Composite CUser;
    protected MyLabel lblUserName;
    protected MyLabel lblUserPass;
    protected MyLabel lblUserPassConfirm;
    protected MyButton chkUser;
    protected MyMaskedText txtUserName;
    protected MyMaskedText txtUserPass;
    protected MyMaskedText txtUserPassConfirm;
    protected Table tblRoles;
    protected Table tblRolesCrisis;
    protected MyCalendarText txtRoleCrisisEndDate;
    protected MyButton chkRoleCrisisEnabled;
    protected MyButton btnUnblockUser;
    protected MyLabel lblTo;
    protected MyLabel lblUserValidityDateRange;
    protected MyCalendarText txtFromDate;
    protected MyCalendarText txtToDate;

    public BaseUserControl(Composite parent, int style, PersonMultiEditor parentEditor) {
        super(parent, style);
        this.parentEditor = parentEditor;
    }

    public void createMyControl(Composite parent, FormToolkit toolkit) {
        toolkit.adapt((Composite)this);
        this.CUser = toolkit.createComposite(parent);
        this.CUser.setVisible(false);
        this.chkUser = new MyButton(parent, Messages.getString((String)"EST_UN_UTILISATEUR", (String[])new String[0]), 32, toolkit);
        this.lblUserName = new MyLabel(this.CUser, Messages.getString((String)"NOM", (String[])new String[0]), 0, toolkit);
        this.txtUserName = new MyMaskedText(this.CUser, 0, toolkit);
        this.txtUserName.setMask(new MyMask(MyMask.toLength((char)'#', (int)30), 32));
        this.txtUserName.showRequiredFieldDecorator(true);
        this.lblUserPass = new MyLabel(this.CUser, Messages.getString((String)"MOT_DE_PASSE", (String[])new String[0]), 0, toolkit);
        char cbit = '\u2a2a';
        this.txtUserPass = new MyMaskedText(this.CUser, 0, toolkit);
        this.txtUserPass.setMask(new MyMask(MyMask.toLength((char)'!', (int)30)));
        this.txtUserPass.setEchoChar(LibPlugin.ON_MAC ? cbit : (char)'*');
        this.txtUserPass.showRequiredFieldDecorator(true);
        this.lblUserPassConfirm = new MyLabel(this.CUser, Messages.getString((String)"CONFIRMATION_MOT_DE_PASSE", (String[])new String[0]), 0, toolkit);
        this.txtUserPassConfirm = new MyMaskedText(this.CUser, 0, toolkit);
        this.txtUserPass.setMask(new MyMask(MyMask.toLength((char)'!', (int)30)));
        this.txtUserPassConfirm.setEchoChar(LibPlugin.ON_MAC ? cbit : (char)'*');
        this.txtUserPassConfirm.showRequiredFieldDecorator(true);
        FontAwareGroup groupRole = new FontAwareGroup(this.CUser, toolkit);
        groupRole.setText("R\u00f4le(s) habituel(s)");
        this.tblRoles = new Table((Composite)groupRole, 546);
        FontAwareGroup groupRoleCrisis = new FontAwareGroup(this.CUser, toolkit);
        groupRoleCrisis.setText("R\u00f4le(s) lors d'une situation de crise");
        this.chkRoleCrisisEnabled = new MyButton((Composite)groupRoleCrisis, "Mode activ\u00e9", 32, toolkit);
        MyLabel lblRoleCrisisEndDate = new MyLabel((Composite)groupRoleCrisis, "Date de fin", 16384, toolkit);
        this.txtRoleCrisisEndDate = new MyCalendarText((Composite)groupRoleCrisis, 0, toolkit);
        this.tblRolesCrisis = new Table((Composite)groupRoleCrisis, 546);
        this.btnUnblockUser = new MyButton(this.CUser, Messages.getString((String)"DEBLOQUER", (String[])new String[0]), 8, toolkit);
        this.btnUnblockUser.setVisible(false);
        this.lblTo = new MyLabel(this.CUser, "-", 16384, toolkit);
        this.lblUserValidityDateRange = new MyLabel(this.CUser, Messages.getString((String)"INTERVAL_ACTIVITE", (String[])new String[0]), 16384, toolkit);
        this.txtFromDate = new MyCalendarText(this.CUser, 0, toolkit);
        this.txtToDate = new MyCalendarText(this.CUser, 0, toolkit);
        this.chkUser.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseUserControl.this.getParentEditor().getPerson().setIsUser(Boolean.valueOf(BaseUserControl.this.chkUser.getSelection()));
                if (BaseUserControl.this.getUser() == null) {
                    BaseUserControl.this.getParentEditor().getPerson().setUser(new XUser());
                    BaseUserControl.this.getUser().initialize();
                } else {
                    BaseUserControl.this.getUser().setIsDeleted(Boolean.valueOf(!BaseUserControl.this.chkUser.getSelection()));
                }
                BaseUserControl.this.CUser.setVisible(BaseUserControl.this.chkUser.getSelection());
            }
        });
        this.txtUserName.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseUserControl.this.getUser().setName(BaseUserControl.this.txtUserName.getText());
            }
        });
        this.tblRoles.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 13){

            public void edited(Event e) {
                EnumSet<XUserRole> er = EnumSet.noneOf(XUserRole.class);
                TableItem[] tableItemArray = BaseUserControl.this.tblRoles.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        er.add((XUserRole)item.getData());
                    }
                    ++n2;
                }
                BaseUserControl.this.getUser().setRole(er);
            }
        });
        this.tblRolesCrisis.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 13){

            public void edited(Event e) {
                EnumSet<XUserRole> er = EnumSet.noneOf(XUserRole.class);
                TableItem[] tableItemArray = BaseUserControl.this.tblRolesCrisis.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        er.add((XUserRole)item.getData());
                    }
                    ++n2;
                }
                BaseUserControl.this.getUser().setCrisisRole(er);
            }
        });
        this.chkRoleCrisisEnabled.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseUserControl.this.getUser().setCrisisRoleEnabled(Boolean.valueOf(BaseUserControl.this.chkRoleCrisisEnabled.getSelection()));
            }
        });
        this.txtRoleCrisisEndDate.addDateListener((DateText.IDateListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 16384){

            public void edited(Event e) {
                BaseUserControl.this.getUser().setCrisisRoleEndDate((LocalDate)e.data);
            }
        });
        this.txtUserPass.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                try {
                    BaseUserControl.this.getUser().setEncryptedPassword(DesEncrypter.encryptMe((String)BaseUserControl.this.txtUserPass.getText()));
                }
                catch (EncryptionException encryptionException) {
                    MessageUtil.unexpectedExceptionMsg((Shell)BaseUserControl.this.getShell());
                }
            }
        });
        this.txtUserPassConfirm.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                try {
                    BaseUserControl.this.getUser().setEncryptedPasswordConfirm(DesEncrypter.encryptMe((String)BaseUserControl.this.txtUserPassConfirm.getText()));
                }
                catch (EncryptionException encryptionException) {
                    MessageUtil.unexpectedExceptionMsg((Shell)BaseUserControl.this.getShell());
                }
            }
        });
        this.btnUnblockUser.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor()){

            public void edited(Event e) {
                BaseUserControl.this.doUnblockUser();
            }
        });
        this.txtFromDate.addDateListener((DateText.IDateListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 16384){

            public void edited(Event e) {
                BaseUserControl.this.getUser().setValidFromDate((LocalDate)e.data);
            }
        });
        this.txtToDate.addDateListener((DateText.IDateListener)new EditorModifyListener((IBaseEditor2)this.getParentEditor(), 16384){

            public void edited(Event e) {
                BaseUserControl.this.getUser().setValidToDate((LocalDate)e.data);
            }
        });
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        this.setLayout((Layout)formLayout);
        this.CUser.setLayout((Layout)formLayout);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(2);
        data.right = new FormAttachment(98);
        this.chkUser.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(this.chkUser.getControl());
        data.right = new FormAttachment(100);
        this.CUser.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        this.lblUserName.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(this.lblUserName.getControl());
        data.width = 150;
        this.txtUserName.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(this.txtUserName.getControl());
        this.lblUserPass.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(this.lblUserPass.getControl());
        data.width = 150;
        this.txtUserPass.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(this.txtUserPass.getControl());
        data.top = new FormAttachment(this.lblUserPass.getControl(), 0, 128);
        this.lblUserPassConfirm.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(this.lblUserPassConfirm.getControl(), 0, 16384);
        data.top = new FormAttachment(this.lblUserPassConfirm.getControl());
        data.width = 150;
        this.txtUserPassConfirm.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(this.txtUserPassConfirm.getControl());
        this.lblUserValidityDateRange.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(this.lblUserValidityDateRange.getControl());
        this.txtFromDate.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(this.txtFromDate.getControl());
        data.top = new FormAttachment(this.lblUserValidityDateRange.getControl());
        this.lblTo.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(this.lblTo.getControl());
        data.top = new FormAttachment(this.lblUserValidityDateRange.getControl());
        this.txtToDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtToDate.getControl());
        data.left = new FormAttachment(0);
        this.btnUnblockUser.setLayoutData((Object)data);
        FillLayout groupRoleLayout = new FillLayout();
        groupRoleLayout.marginWidth = 4;
        groupRoleLayout.marginHeight = 4;
        groupRole.setLayout((Layout)groupRoleLayout);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(this.btnUnblockUser.getControl());
        groupRole.setLayoutData((Object)data);
        FormLayout groupRoleCrisisLayout = new FormLayout();
        groupRoleCrisisLayout.spacing = 5;
        groupRoleCrisisLayout.marginTop = 5;
        groupRoleCrisisLayout.marginRight = 5;
        groupRoleCrisis.setLayout((Layout)groupRoleCrisisLayout);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)groupRole);
        groupRoleCrisis.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.tblRolesCrisis.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.tblRolesCrisis);
        this.chkRoleCrisisEnabled.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtRoleCrisisEndDate.getControl(), 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tblRolesCrisis);
        lblRoleCrisisEndDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.chkRoleCrisisEnabled);
        data.left = new FormAttachment(lblRoleCrisisEndDate.getControl());
        this.txtRoleCrisisEndDate.setLayoutData((Object)data);
        groupRoleCrisis.pack();
        toolkit.paintBordersFor(parent);
    }

    protected void doUnblockUser() {
        try {
            JobCallback callback = new JobCallback(Messages.getString((String)"DEBLOQUER", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    if (response.getStatus().isOkToProceed()) {
                        BaseUserControl.this.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageUtil.infoMsg((Shell)BaseUserControl.this.getShell(), (String)"Utilisateur d\u00e9bloqu\u00e9. Fermer l'\u00e9diteur pour rafraichir.");
                                (this).BaseUserControl.this.getUser().isBlocked = false;
                            }
                        });
                    }
                }
            };
            UserAccessorClient.getInstance().unblockUser((ICallback)callback, Application.get().getGlobalInstances().getSession(), this.getUser().getId().intValue());
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
    }

    public Table getTblRoles() {
        return this.tblRoles;
    }

    public Table getTblRolesCrisis() {
        return this.tblRolesCrisis;
    }

    public void setTblRoles(List<XUserRole> roles) {
        TableItem ti;
        this.tblRoles.clearAll();
        for (XUserRole role : roles) {
            ti = new TableItem(this.tblRoles, 0);
            ti.setText(role.toString());
            ti.setData((Object)role);
        }
        this.tblRolesCrisis.clearAll();
        for (XUserRole role : roles) {
            ti = new TableItem(this.tblRolesCrisis, 0);
            ti.setText(role.toString());
            ti.setData((Object)role);
        }
    }

    protected XUser getUser() {
        XPerson person = this.getParentEditor().getPerson();
        return person == null ? null : person.getUser();
    }

    public abstract void showCurrentUser();

    public PersonMultiEditor getParentEditor() {
        return this.parentEditor;
    }
}

