/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.site;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.BaseSectionSwitchTable;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.person.site.SitesControl;
import ca.infodata.ofys.ui.site.DrugStoreSiteCombo;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.PredicateA;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DrugStoreSitesControl
extends SitesControl {
    public DrugStoreSitesControl(Composite parent, IBaseEditor parentEditor, FormToolkit toolkit) {
        super(parent, parentEditor, toolkit);
        this.setDisplayPredicate((PredicateA)new PredicateA<XPersonSite>(){

            public boolean evaluate(XPersonSite s) {
                if (s == null) {
                    return false;
                }
                XSite site = SitePlugin.getDefault().getSite(s.getIdSite());
                if (site == null) {
                    return false;
                }
                return s.getAddedAs() == SiteAddedAs.DRUG_STORE;
            }
        });
    }

    @Override
    protected void createEditionControl(Composite parent) {
        super.createEditionControl(parent);
        this.cmbSite.getControl().dispose();
        this.cmbSite = new DrugStoreSiteCombo(parent, 8, this.toolkit);
        ControlDecorator.decorateWithRequiredField((Control)this.cmbSite.getControl());
        this.cmbSite.addListener(13, (Listener)new BaseSectionSwitchTable.SwitchTableModifyListener(this){

            public void sectionEdited(Event e) {
                XSite site = DrugStoreSitesControl.this.cmbSite.getSelection();
                DrugStoreSitesControl.this.current.setIdSite(site == null ? null : site.getId());
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 200;
        this.cmbSite.getControl().setLayoutData((Object)data);
    }

    @Override
    protected String getTitle() {
        return Messages.getString((String)"PHARMACIES", (String[])new String[0]);
    }

    @Override
    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        XPersonSite s = (XPersonSite)dataObject;
        this.error = "";
        if (s.getIdSite() == null) {
            this.error = Messages.getString((String)"SELECTIONNEZ_PHARMACIE", (String[])new String[0]);
            return false;
        }
        return true;
    }

    @Override
    protected XPersonSite initializeNewDataObject() {
        XPersonSite s = super.initializeNewDataObject();
        s.setAddedAs(SiteAddedAs.DRUG_STORE);
        return s;
    }
}

