/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.person.patient.BasePatientControl;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchView;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatientControl
extends BasePatientControl {
    public PatientControl(Composite parent, FormToolkit toolkit, PatientMultiEditor parentEditor) {
        super(parent, toolkit, parentEditor);
    }

    @Override
    public void showCurrentPatient() {
        XPatient patient = this.getParentEditor().getPatient();
        this.txtFather.setDataObject((IDataObject)patient.getFather());
        this.txtMother.setDataObject((IDataObject)patient.getMother());
        this.txtTutor.setDataObject((IDataObject)patient.getTutor());
        this.txtTutorName.setText(patient.getTutorName());
        this.txtFatherName.setText(patient.getFatherName());
        this.txtMotherName.setText(patient.getMotherName());
        this.txtSpouseName.setText(patient.getSpouseName());
        this.txtPatientRecordNumber.setText(patient.getPatientRecordNumber());
        this.txtHealthInsuranceNumber.setText(patient.getHealthInsuranceNumber());
        this.txtTreatingProfessionnal.setDataObjectId(patient.getTreatingProfessionnal());
        this.txtLastVerificationDate.setDate((IPartialDate)patient.getLastVerificationDate());
        this.txtLastActivityDate.setDate((IPartialDate)patient.getLastActivityDate());
        this.txtExpirationCAM.setText(patient.getExpirationCAM());
        this.txtMessageAppointment.setText(patient.getMessageAppointment());
        this.txtCustodyTerms.setText(patient.getCustodyTerms());
        this.txtMessageAppointmentVariableReplacer.setDataObject((Object)patient);
        this.txtMessageAppointmentVariableReplacer.setToday(LocalDate.today());
        this.chkIsSensible.setSelection(Boolean.TRUE.equals(patient.getIsSensible()));
        this.chkIsScanned.setSelection(Boolean.TRUE.equals(patient.getIsScanned()));
        this.btnSofyAuthorizedUndefined.setSelection(patient.getSofyAuthorized() == null);
        this.btnSofyAuthorizedFalse.setSelection(Boolean.FALSE.equals(patient.getSofyAuthorized()));
        this.btnSofyAuthorizedTrue.setSelection(Boolean.TRUE.equals(patient.getSofyAuthorized()));
    }

    protected String getFormatedPatientRecordNumberFromControl() {
        String strZero = "0000000000" + this.txtPatientRecordNumber.getText();
        return strZero.substring(strZero.length() - Application.get().getGlobalInstances().getSession().getClientPreferences().getPatientRecordNumberLength());
    }

    @Override
    protected void btnSearchTreatingProfessionnalSelected() {
        this.txtTreatingProfessionnal.setData("isTreatingProfessionnal", new Boolean(true));
        ProfessionnalSearchView view = (ProfessionnalSearchView)BaseSearchView.openView(ProfessionnalSearchView.class, (Object)this.txtTreatingProfessionnal);
        view.setType(-1);
    }
}

