/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElementsFactory;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.group.PersonGroupListElement;
import ca.infodata.ofys.ui.person.menu.FusionPatientEditorElement;
import ca.infodata.ofys.ui.person.menu.ListActiveSessionsElement;
import ca.infodata.ofys.ui.person.menu.ListEmployee;
import ca.infodata.ofys.ui.person.menu.ListProfessionnel;
import ca.infodata.ofys.ui.person.menu.ListUser;
import ca.infodata.ofys.ui.person.menu.ListUserBlocked;
import ca.infodata.ofys.ui.person.menu.PatientRootElement;
import ca.infodata.ofys.ui.person.menu.element.CurrentPatientElements;
import ca.infodata.ofys.ui.person.menu.element.ProfessionnalElements;
import ca.infodata.ofys.ui.person.menu.identifiers.ListIdentifierType;
import ca.infodata.ofys.ui.person.patient.search.menu.SearchRootElement;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;

public class PersonTreeElementsFactory
implements ITreeElementsFactory {
    public List<? extends ITreeElements> newITreeElements(ITreeElements parent, IConfigurationElement e) {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            String c = e.getAttribute("class");
            if (c.equals(ListActiveSessionsElement.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.LIST_ACTIVES_SESSIONS)) {
                    return Arrays.asList(new ListActiveSessionsElement(parent));
                }
                return null;
            }
            if (c.equals(ListIdentifierType.class.getName())) {
                return Arrays.asList(new ListIdentifierType(parent));
            }
            if (c.equals(ListUser.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_USER)) {
                    return Arrays.asList(new ListUser(parent));
                }
                return null;
            }
            if (c.equals(ListUserBlocked.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_USER)) {
                    return Arrays.asList(new ListUserBlocked(parent));
                }
                return null;
            }
            if (c.equals(ListEmployee.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_EMPLOYEE)) {
                    return Arrays.asList(new ListEmployee(parent));
                }
                return null;
            }
            if (c.equals(FusionPatientEditorElement.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.FUSION_PATIENT)) {
                    return Arrays.asList(new FusionPatientEditorElement(parent));
                }
                return null;
            }
            if (c.equals(PatientRootElement.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.PATIENT)) {
                    return Arrays.asList(new PatientRootElement(parent));
                }
                return null;
            }
            if (c.equals(ListProfessionnel.class.getName())) {
                return Arrays.asList(new ListProfessionnel(parent));
            }
            if (c.equals(CurrentPatientElements.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.PATIENT)) {
                    return Arrays.asList(new CurrentPatientElements(parent, PersonUiPlugin.getDefault().getCurrentPatient()));
                }
                return null;
            }
            if (c.equals(PersonGroupListElement.class.getName())) {
                return Arrays.asList(new PersonGroupListElement(parent));
            }
            if (c.equals(ProfessionnalElements.class.getName()) && Application.get().getGlobalInstances().getSession() != null) {
                ArrayList<ProfessionnalElements> lstChilds = new ArrayList<ProfessionnalElements>();
                XBaseProfessionnal baseProfessionnal = PersonUiPlugin.getDefault().getSessionProfessionnal();
                if (baseProfessionnal != null) {
                    lstChilds.add(new ProfessionnalElements(parent, baseProfessionnal));
                    Stream<XBaseProfessionnal> replacements = PersonUiPlugin.getDefault().getWhoProfReplace(baseProfessionnal.getId(), LocalDate.today()).sorted(new Comparator<XBaseProfessionnal>(){

                        @Override
                        public int compare(XBaseProfessionnal o1, XBaseProfessionnal o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1 == null) {
                                return -1;
                            }
                            if (o2 == null) {
                                return 1;
                            }
                            return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
                        }
                    });
                    Iterator iterator = replacements.iterator();
                    while (iterator.hasNext()) {
                        XBaseProfessionnal prof = (XBaseProfessionnal)iterator.next();
                        lstChilds.add(new ProfessionnalElements(parent, prof));
                    }
                    return lstChilds;
                }
                return null;
            }
            if (c.equals(SearchRootElement.class.getName())) {
                if (Application.get().getGlobalInstances().hasRight(XRight.MAKE_ADVANCED_PATIENT_SEARCH)) {
                    return Arrays.asList(new SearchRootElement(parent));
                }
                return null;
            }
            throw new RuntimeException("unsuppored class tag " + c);
        }
        return null;
    }
}

