/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.identifiers;

import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.FacilityAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XIdentifierType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.identifiers.BaseIdentifierTypeEditor;
import ca.infodata.ofys.ui.person.identifiers.TypeAddressAdapter;
import java.io.Serializable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class IdentifierTypeEditor
extends BaseIdentifierTypeEditor {
    @Override
    public void createMyControl(Composite parent) {
        super.createMyControl(parent);
    }

    public void setPartName(String partName) {
        XIdentifierType f = this.getType();
        if (f != null) {
            partName = f.getId() == null ? Messages.getString((String)"NOUVEAU_TYPE_DIDENTIFICATEUR", (String[])new String[0]) : f.getName();
        }
        super.setPartName(partName);
    }

    public void showDataObject() {
        XIdentifierType o = this.getType();
        if (o == null) {
            this.chkIsDeleted.setEnabled(false);
            this.chkIsDeleted.setSelection(false);
            this.chkPrintithRecordNumber.setEnabled(false);
            this.chkPrintithRecordNumber.setSelection(false);
            this.address.setAddress(null);
            this.address.showCurrentAddress();
            this.txtNoTel.setEnabled(false);
            this.txtNoTel2.setEnabled(false);
            this.txtNoTel.clear();
            this.txtNoTel2.clear();
        } else {
            this.chkIsDeleted.setEnabled(true);
            this.chkIsDeleted.setSelection(!Boolean.TRUE.equals(o.getIsDeleted()));
            this.chkPrintithRecordNumber.setEnabled(true);
            this.chkPrintithRecordNumber.setSelection(Boolean.TRUE.equals(o.getPrintWithRecordNumber()));
            this.address.setAddress(new TypeAddressAdapter(this.getType()));
            this.address.showCurrentAddress();
            this.txtNoTel.setEnabled(true);
            this.txtNoTel2.setEnabled(true);
            this.txtNoTel.setText(o.getPhonenumber1());
            this.txtNoTel2.setText(o.getPhonenumber2());
        }
        this.identifierTypeControl.show();
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return FacilityAccessorClient.getInstance();
    }

    public void initDataOverride() {
        if (!(((EditorInput)this.getEditorInput()).getDataObject() instanceof XIdentifierType)) {
            throw new IllegalStateException("Only XIdentifierType EditorInput is supported");
        }
        this.initializeCompleteDataObject((EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject().clone());
    }

    public boolean isDataDirty() {
        return this.getType().isDirty();
    }

    public void print() {
        if (this.isDirty()) {
            Runnable printCallback = new Runnable(){

                @Override
                public void run() {
                    if (IdentifierTypeEditor.this.getLastSaveOrDeleteStatus() != null && IdentifierTypeEditor.this.getLastSaveOrDeleteStatus().isOK() && IdentifierTypeEditor.this.getType() != null && !IdentifierTypeEditor.this.isDirty()) {
                        PrintDialog2 dialog = new PrintDialog2(IdentifierTypeEditor.this.getSite().getShell(), (Serializable)IdentifierTypeEditor.this.getType());
                        UI.centerComposite((Composite)dialog.getShell(), (Composite)IdentifierTypeEditor.this.getEditorSite().getShell());
                        dialog.open();
                    }
                }
            };
            this.doSave(printCallback);
        } else if (this.getType() != null) {
            PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), (Serializable)this.getType());
            UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
            dialog.open();
        }
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/identifier.gif");
    }

    public void setToolBarStatus() {
    }
}

