/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.employee;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.person.employee.BaseEmployeeEditor;
import java.util.Collections;
import org.eclipse.swt.widgets.Composite;

public class EmployeeEditor
extends BaseEmployeeEditor {
    public EmployeeEditor(BaseMultiEditor parentEditor) {
        super(parentEditor);
    }

    @Override
    protected XEmployee getEmployee() {
        return (XEmployee)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }

    @Override
    protected XPerson getPerson() {
        return this.getEmployee();
    }

    public void load() {
        if (Application.get().getGlobalInstances().getSession().getUser().getUserPreferences().getIsAdvancedUser() == 1) {
            this.sectionEmployee.setExpanded(true);
        }
    }

    public void showDataObjectOverride() {
        if (this.getPerson() == null) {
            this.sectionPerson.setEnabled(false);
            this.sectionEmployee.setEnabled(false);
            this.sectionUser.setEnabled(false);
            this.addressControl.setEnabled(false);
            this.contactControl.setEnabled(false);
            this.personControl.setEnabled(false);
            this.userControl.setEnabled(false);
            this.employee.setEnabled(false);
            this.addressControl.setStatusList(EditableDataObjectList.EMPTY_LIST);
            this.contactControl.setStatusList(EditableDataObjectList.EMPTY_LIST);
            this.siteControl.setStatusList(EditableDataObjectList.EMPTY_LIST);
        } else {
            this.sectionPerson.setEnabled(true);
            this.sectionEmployee.setEnabled(true);
            this.sectionUser.setEnabled(true);
            this.addressControl.setEnabled(true);
            this.contactControl.setEnabled(true);
            this.personControl.setEnabled(true);
            this.userControl.setEnabled(true);
            this.employee.setEnabled(true);
            Collections.sort(this.getPerson().getLstAddress(), XPerson.compImportance);
            Collections.sort(this.getPerson().getLstContactInformation(), XPerson.compImportance);
            this.addressControl.setStatusList((IEditableDataObjectList)this.getPerson().getLstAddress());
            this.contactControl.setStatusList((IEditableDataObjectList)this.getPerson().getLstContactInformation());
            this.siteControl.setStatusList(this.getPerson().getLstSites());
        }
        this.personControl.showCurrentPerson();
        boolean showSectionUser = Application.get().getGlobalInstances().hasRight(XRight.EDIT_USER);
        this.sectionUser.setVisible(showSectionUser);
        this.userControl.showCurrentUser();
        this.employee.showCurrentEmployee();
    }

    @Override
    protected void createSubControlEx(Composite subCompositeEx) {
    }
}

