/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.BaseSubEditor;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IEditionListener;
import ca.infodata.ofys.ui.person.PersonControl;
import ca.infodata.ofys.ui.person.PersonMultiEditor;
import ca.infodata.ofys.ui.person.address.AddressControl;
import ca.infodata.ofys.ui.person.contact.ContactInformationControl;
import ca.infodata.ofys.ui.person.site.SitesControl;
import ca.infodata.ofys.ui.person.user.UserControl;
import ca.infodata.util1.StringUtils;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;

public abstract class BasePersonEditor
extends BaseSubEditor
implements IEditorPart {
    protected static final String PERSONNE = Messages.getString((String)"PERSONNE", (String[])new String[0]);
    protected PersonControl personControl;
    protected FontAwareSection sectionPerson;
    private Composite subComposite;
    private Composite subCompositeEx;
    protected AddressControl addressControl;
    protected boolean addressControlShowValidationStatus;
    protected ContactInformationControl contactControl;
    protected boolean contactControlShowValidationStatus;
    protected SitesControl siteControl;
    protected UserControl userControl;
    protected FontAwareSection sectionUser;
    protected Control lastControl;
    protected long lastTimeAutoFocus = 0L;

    public BasePersonEditor(BaseMultiEditor parentEditor) {
        super(parentEditor);
    }

    public void createMyControl(Composite parent) {
        System.out.println("BasePersonEditor");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.sectionPerson = new FontAwareSection(parent, 66, this.toolkit);
        this.sectionPerson.setText(PERSONNE);
        this.toolkit.createCompositeSeparator((Composite)this.sectionPerson);
        this.personControl = new PersonControl((Composite)this.sectionPerson, this.toolkit, (PersonMultiEditor)this.getParentEditor());
        this.sectionPerson.setClient((Control)this.personControl);
        this.sectionPerson.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                BasePersonEditor.this.personControl.setFirstFocus();
            }
        });
        this.sectionPerson.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                BasePersonEditor.this.personControl.setFocusToFirst();
            }
        });
        this.sectionUser = new FontAwareSection(parent, 66, this.toolkit);
        this.sectionUser.setText(Messages.getString((String)"UTILISATEUR", (String[])new String[0]));
        this.toolkit.createCompositeSeparator((Composite)this.sectionUser);
        this.sectionUser.setLayout((Layout)new FormLayout());
        this.userControl = new UserControl((Composite)this.sectionUser, this.toolkit, (PersonMultiEditor)this.getParentEditor());
        this.sectionUser.setClient((Control)this.userControl);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.userControl.setLayoutData(data);
        this.subComposite = this.toolkit.createComposite(parent);
        this.createSubControl(this.subComposite);
        this.addressControl = new AddressControl(parent, (PersonMultiEditor)this.getParentEditor(), this.toolkit){

            protected int getInternalSectionStyle() {
                return super.getInternalSectionStyle() | 0x40;
            }
        };
        this.contactControl = new ContactInformationControl(parent, (PersonMultiEditor)this.getParentEditor(), this.toolkit, this.contactControlShowValidationStatus){

            protected int getInternalSectionStyle() {
                return super.getInternalSectionStyle() | 0x40;
            }
        };
        this.siteControl = new SitesControl(parent, (IBaseEditor)this.getParentEditor(), this.toolkit);
        this.subCompositeEx = this.toolkit.createComposite(parent);
        this.createSubControlEx(this.subCompositeEx);
        this.addressControl.getSection().getChildren()[0].addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent arg0) {
                if (Calendar.getInstance().getTimeInMillis() - BasePersonEditor.this.lastTimeAutoFocus > 1000L) {
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!((this).this).BasePersonEditor.this.contactControl.getSection().isDisposed()) {
                                        ((this).this).BasePersonEditor.this.lastTimeAutoFocus = Calendar.getInstance().getTimeInMillis();
                                        ((this).this).BasePersonEditor.this.contactControl.getSection().setFocus();
                                    }
                                }
                            });
                        }
                    };
                    Timer t = new Timer();
                    t.schedule(task, 20L);
                    TimerTask task2 = new TimerTask(){

                        @Override
                        public void run() {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!((this).this).BasePersonEditor.this.addressControl.getSection().isDisposed()) {
                                        ((this).this).BasePersonEditor.this.addressControl.getSection().setFocus();
                                    }
                                }
                            });
                        }
                    };
                    Timer t2 = new Timer();
                    t2.schedule(task2, 40L);
                }
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.sectionPerson.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionPerson, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        if (this.subComposite.getChildren() != null && this.subComposite.getChildren().length == 0) {
            data.height = 0;
        }
        this.subComposite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.subComposite, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.addressControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.addressControl, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.contactControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.contactControl, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.siteControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.siteControl, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        if (this.subCompositeEx.getChildren() != null && this.subCompositeEx.getChildren().length == 0) {
            data.height = 0;
        }
        this.subCompositeEx.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.subCompositeEx, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.sectionUser.setLayoutData((Object)data);
        this.lastControl = this.sectionUser;
    }

    public void addEditionListener(IEditionListener listener) {
        this.lstListener.add(listener);
    }

    protected abstract XPerson getPerson();

    protected abstract void createSubControl(Composite var1);

    protected abstract void createSubControlEx(Composite var1);

    public Composite getSubComposite() {
        return this.subComposite;
    }

    public Composite getSubCompositeEx() {
        return this.subCompositeEx;
    }

    public AddressControl getAddress() {
        return this.addressControl;
    }

    public ContactInformationControl getContact() {
        return this.contactControl;
    }

    public SitesControl getSiteControl() {
        return this.siteControl;
    }

    public void justBeforeSaving() {
        EditableDataObjectList contactInformations;
        XPerson person = this.getPerson();
        XContactInformation texto = null;
        XContactInformation email = null;
        if (person != null && (contactInformations = person.getLstContactInformation()) != null && !contactInformations.isEmpty()) {
            for (XContactInformation item : contactInformations) {
                if (StringUtils.isBlank((CharSequence)item.getContact()) && StringUtils.isBlank((CharSequence)item.getNote())) {
                    item.setDeleted();
                    continue;
                }
                if (item.getTypeContact().intValue() == XContactInformation.CONTACT_TYPE_CELL_TEXTO.intValue()) {
                    if (texto == null) {
                        texto = item;
                        continue;
                    }
                    item.setTypeContact(XContactInformation.CONTACT_TYPE_CELL_AUTRE);
                    continue;
                }
                if (item.getTypeContact().intValue() != XContactInformation.CONTACT_TYPE_EMAIL.intValue()) continue;
                if (email == null) {
                    email = item;
                    continue;
                }
                item.setTypeContact(XContactInformation.CONTACT_TYPE_EMAILS_AUTRES);
            }
        }
        super.justBeforeSaving();
    }
}

