/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.EmployeeAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseEmployeeCache
extends ObjectCache<XBaseEmployee> {
    private static final Logger logger = Logger.getLogger(BaseEmployeeCache.class.getName());
    private static final String EMP_PERSON = "baseemp-person";
    private static final String EMP = "baseemp";
    private IConsumerListenerImplementation listener = new IConsumerListenerImplementation();

    public BaseEmployeeCache() {
        super(EMP);
        Application.get().getGlobalInstances().getNotificationSystem().addListener((IConsumerListener)this.listener);
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAllAsync(session, callback, XBaseEmployee.class.getName());
    }

    protected void add(Map<ObjectCache.Key, XBaseEmployee> map, XBaseEmployee e) {
        if (e != null) {
            map.put(new ObjectCache.Key(EMP, e.getId()), e);
            map.put(new ObjectCache.Key(EMP_PERSON, e.getIdPerson()), e);
        }
    }

    public XBaseEmployee getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, true);
    }

    public List<XBaseEmployee> getAll() {
        return new ArrayList<XBaseEmployee>(this.getMap().values());
    }

    public XBaseEmployee getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseEmployee)this.get(new ObjectCache.Key(EMP, id), logIfNotFound, mustTryToFindServer);
    }

    public XBaseEmployee getByIdPerson(Integer id, boolean logIfNotFound) {
        return this.getByIdPerson(id, logIfNotFound, true);
    }

    public XBaseEmployee getByIdPerson(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseEmployee)this.get(new ObjectCache.Key(EMP_PERSON, id), logIfNotFound, mustTryToFindServer);
    }

    protected XBaseEmployee loadSync(XSession session, ObjectCache.Key key) throws Exception {
        if (key == null) {
            return null;
        }
        if (EMP.equals(key.type)) {
            return (XBaseEmployee)EmployeeAccessorClient.getInstance().getEmployeeSync(session, key.id.intValue(), true);
        }
        if (EMP_PERSON.equals(key.type)) {
            return (XBaseEmployee)EmployeeAccessorClient.getInstance().getEmployeeByIdPersonSync(session, key.id.intValue(), true);
        }
        return null;
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAll(session, callback, XBaseEmployee.class.getName());
    }

    private final class IConsumerListenerImplementation
    implements IConsumerListener {
        private IConsumerListenerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                if (notification != null) {
                    IDataObject object = notification.getObject();
                    if (object instanceof XBaseEmployee) {
                        BaseEmployeeCache.this.add((Map<ObjectCache.Key, XBaseEmployee>)BaseEmployeeCache.this.getMap(), (XBaseEmployee)object);
                    } else if (object instanceof XEmployee) {
                        BaseEmployeeCache.this.add((Map<ObjectCache.Key, XBaseEmployee>)BaseEmployeeCache.this.getMap(), new XBaseEmployee((XEmployee)object));
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListenerImplementation.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                BaseEmployeeCache.this.reload(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in EmployeeCache.forceRefresh", e);
            }
        }
    }
}

