/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.apache.log4j.Logger;

public class ObservedProcess {
    private static Logger logger = Logger.getLogger(ObservedProcess.class);
    private Process proc;

    public ObservedProcess(Process proc) {
        this.proc = proc;
    }

    public int waitForProcess(Writer output, Writer error) throws InterruptedException {
        StreamObserver outputObserver = new StreamObserver(this.proc.getInputStream(), output);
        StreamObserver errorObserver = new StreamObserver(this.proc.getErrorStream(), error);
        outputObserver.start();
        errorObserver.start();
        int exitVal = this.proc.waitFor();
        errorObserver.join();
        outputObserver.join();
        return exitVal;
    }

    private class StreamObserver
    extends Thread {
        private InputStream is;
        private Writer output;

        public StreamObserver(InputStream is, Writer output) {
            this.is = is;
            this.output = output;
        }

        @Override
        public void run() {
            super.run();
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    if (this.output == null) continue;
                    this.output.append(line);
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error reading process output in StreamObserver: ", (Throwable)e);
            }
        }
    }
}

