/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.awt.Color;
import java.util.regex.Pattern;

public class ColorUtil {
    protected static Pattern SPLIT_RGBA_PATTERN = Pattern.compile("^\\p{Blank}*|\\p{Blank}*\\{\\p{Blank}*|\\p{Blank}*\\}\\p{Blank}*$|,\\p{Blank}*");

    protected ColorUtil() {
    }

    protected static RGBA parseRGBA(String color) {
        RGBA rgba = new RGBA();
        String[] parts = SPLIT_RGBA_PATTERN.split(color);
        if (!"RGBA".equals(parts[1]) && !"RGB".equals(parts[1])) {
            throw new IllegalArgumentException("color is neither RGB nor RGBA encoded! It must start with 'RGB' or 'RGBA'!");
        }
        if (parts.length < 5) {
            throw new IllegalArgumentException("color is incomplete! It must at least contain three decimal numbers specifying red, green and blue! It should specify alpha as forth value.");
        }
        rgba.r = Integer.parseInt(parts[2]);
        rgba.g = Integer.parseInt(parts[3]);
        rgba.b = Integer.parseInt(parts[4]);
        rgba.a = parts.length >= 6 ? Integer.parseInt(parts[5]) : 255;
        if (rgba.r < 0 || rgba.g < 0 || rgba.b < 0 || rgba.a < 0) {
            throw new IllegalArgumentException("color is invalid! One of the values for red, gree, blue or alpha is less than 0!");
        }
        if (rgba.r > 255 || rgba.g > 255 || rgba.b > 255 || rgba.a > 255) {
            throw new IllegalArgumentException("color is invalid! One of the values for red, gree, blue or alpha is greater than 255!");
        }
        return rgba;
    }

    public static String colorToString(Color color) {
        return "RGBA{" + color.getRed() + ',' + color.getGreen() + ',' + color.getBlue() + ',' + color.getAlpha() + '}';
    }

    public static String colorToString(int red, int green, int blue, int alpha) {
        return "RGBA{" + red + ',' + green + ',' + blue + ',' + alpha + '}';
    }

    public static Color stringToColor(String color) {
        RGBA rgba = ColorUtil.parseRGBA(color);
        return new Color(rgba.r, rgba.g, rgba.b, rgba.a);
    }

    public static Color darker(Color c, int multiplier) {
        if (multiplier <= 0) {
            return c;
        }
        Color returnColor = c;
        int i = 0;
        while (i < multiplier) {
            returnColor = returnColor.darker();
            ++i;
        }
        return returnColor;
    }

    public static Color brighter(Color c, int multiplier) {
        if (multiplier <= 0) {
            return c;
        }
        Color returnColor = c;
        int i = 0;
        while (i < multiplier) {
            returnColor = returnColor.brighter();
            ++i;
        }
        return returnColor;
    }

    protected static class RGBA {
        public int r;
        public int g;
        public int b;
        public int a;

        protected RGBA() {
        }
    }
}

