/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.print;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import org.apache.log4j.Logger;
import org.nightlabs.print.PrintUtil;
import org.nightlabs.print.PrinterConfiguration;
import org.nightlabs.print.PrinterInterface;
import org.nightlabs.print.PrinterInterfaceFactory;

public class AWTPrinter
implements PrinterInterface {
    private static final Logger logger = Logger.getLogger(AWTPrinter.class);
    private PrinterJob printerJob;
    private PrinterConfiguration configuration;

    public AWTPrinter(PrinterJob printerJob) {
        this.printerJob = printerJob;
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public void setPrinterJob(PrinterJob printerJob) {
        this.printerJob = printerJob;
    }

    @Override
    public void configure(PrinterConfiguration printerConfiguration) throws PrinterException {
        logger.debug((Object)("Configuring AWTPrinter with " + printerConfiguration));
        if (printerConfiguration != null) {
            this.configuration = (PrinterConfiguration)printerConfiguration.clone();
            PrintService service = null;
            if (printerConfiguration.getPrintServiceName() != null) {
                service = PrintUtil.lookupPrintService(printerConfiguration.getPrintServiceName());
            }
            if (service != null) {
                this.printerJob.setPrintService(service);
            }
            if (printerConfiguration.getPageFormat() != null) {
                this.printerJob.defaultPage(printerConfiguration.getPageFormat());
            }
        }
    }

    @Override
    public PrinterConfiguration getConfiguration() {
        return this.configuration;
    }

    public static class Factory
    implements PrinterInterfaceFactory {
        @Override
        public PrinterInterface createPrinterInterface() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            AWTPrinter awtPrinter = new AWTPrinter(printerJob);
            return awtPrinter;
        }
    }
}

