/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io.pcx;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.log4j.Level;
import org.nightlabs.io.pcx.PCXFormatException;
import org.nightlabs.util.Binary;

public class PCXHeader {
    public static byte MANUFACTURER_PC_PAINTBRUSH = (byte)10;
    public static byte VERSION_2_5 = 0;
    public static byte VERSION_2_8p = (byte)2;
    public static byte VERSION_2_8 = (byte)3;
    public static byte VERSION_3_0p = (byte)5;
    public static byte ENCODING_RLE = 1;
    private short manufacturer;
    private short version;
    private short encoding;
    private short depth;
    private int width;
    private int height;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private int hres;
    private int vres;
    private RGBTriple[] palette;
    private short reserved;
    private short colorPlanes;
    private int bytesPerLine;
    private int paletteInfo;

    public PCXHeader(BufferedImage image) throws IOException {
        if (image.getType() != 12) {
            throw new IllegalArgumentException("image.getType() != BufferedImage.TYPE_BYTE_BINARY: We currently support only 1-bit-PCX!");
        }
        this.manufacturer = MANUFACTURER_PC_PAINTBRUSH;
        this.version = VERSION_3_0p;
        this.encoding = ENCODING_RLE;
        this.depth = 1;
        this.xmin = 0;
        this.ymin = 0;
        this.xmax = (short)(image.getWidth() - 1);
        this.ymax = (short)(image.getHeight() - 1);
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.hres = 72;
        this.vres = 72;
        this.palette = new RGBTriple[16];
        int i = 0;
        while (i < this.palette.length) {
            this.palette[i] = i == 1 ? new RGBTriple(255, 255, 255) : new RGBTriple(0, 0, 0);
            ++i;
        }
        this.reserved = 1;
        this.colorPlanes = 1;
        this.bytesPerLine = this.width % 8 == 0 ? this.width / 8 : this.width / 8 + 1;
        this.paletteInfo = 0;
    }

    public void logValues(Level level) {
        this.logString("Manufactor = " + this.getManufacturer(), level);
        this.logString("Version = " + this.getVersionString(), level);
        this.logString("Encoding = " + this.getEncoding(), level);
        this.logString("Bits per Pixel = " + this.getDepth(), level);
        this.logString("X Min = " + this.getXmin(), level);
        this.logString("X Max = " + this.getXmax(), level);
        this.logString("Y Min = " + this.getYmin(), level);
        this.logString("Y Max = " + this.getYmax(), level);
        this.logString("Horizontal Resolution DPI = " + this.getHres(), level);
        this.logString("Vertical Resolution DPI = " + this.getVres(), level);
        this.logString("Width = " + this.getWidth(), level);
        this.logString("Height = " + this.getHeight(), level);
    }

    protected void logString(String s, Level level) {
        System.out.println("PCXHeader: " + s);
    }

    public void write(Binary binary) throws IOException {
        binary.write(this.manufacturer);
        binary.write(this.version);
        binary.write(this.encoding);
        binary.write(this.depth);
        binary.writeReversedUnsignedShort(this.xmin);
        binary.writeReversedUnsignedShort(this.ymin);
        binary.writeReversedUnsignedShort(this.xmax);
        binary.writeReversedUnsignedShort(this.ymax);
        binary.writeReversedUnsignedShort(this.hres);
        binary.writeReversedUnsignedShort(this.vres);
        int i = 0;
        while (i < this.palette.length) {
            RGBTriple rgb = this.palette[i];
            binary.write(rgb.getRed());
            binary.write(rgb.getGreen());
            binary.write(rgb.getBlue());
            ++i;
        }
        binary.write(this.reserved);
        binary.write(this.colorPlanes);
        binary.writeReversedUnsignedShort(this.bytesPerLine);
        binary.writeReversedUnsignedShort(this.paletteInfo);
        i = 0;
        while (i < 58) {
            binary.write(0);
            ++i;
        }
    }

    public PCXHeader(Binary binary) throws IOException {
        this.manufacturer = (short)binary.readUnsignedByte();
        this.version = (short)binary.readUnsignedByte();
        if (this.version != VERSION_2_5 && this.version != VERSION_2_8 && this.version != VERSION_2_8p && this.version != VERSION_3_0p) {
            throw new PCXFormatException("version " + this.version + " not supported!");
        }
        this.encoding = (short)binary.readUnsignedByte();
        if (this.encoding != ENCODING_RLE) {
            throw new PCXFormatException("encoding " + this.encoding + " not supported!");
        }
        this.depth = (short)binary.readUnsignedByte();
        this.xmin = binary.readReversedUnsignedShort();
        this.ymin = binary.readReversedUnsignedShort();
        this.xmax = binary.readReversedUnsignedShort();
        this.ymax = binary.readReversedUnsignedShort();
        this.width = this.xmax - this.xmin + 1;
        this.height = this.ymax - this.ymin + 1;
        this.hres = binary.readReversedUnsignedShort();
        this.vres = binary.readReversedUnsignedShort();
        this.palette = new RGBTriple[16];
        int i = 0;
        while (i < this.palette.length) {
            this.palette[i] = new RGBTriple(binary.readUnsignedByte(), binary.readUnsignedByte(), binary.readUnsignedByte());
            ++i;
        }
        this.reserved = (short)binary.readUnsignedByte();
        this.colorPlanes = (short)binary.readUnsignedByte();
        this.bytesPerLine = binary.readReversedUnsignedShort();
        this.paletteInfo = binary.readReversedUnsignedShort();
        if (this.depth * this.colorPlanes != 1) {
            throw new PCXFormatException("File is not a 1-bit PCX file! Currently, other (colored/grayscale) PCX files are not yet supported! depth=" + this.depth + " colorPlanes=" + this.colorPlanes);
        }
        binary.skip(58L);
    }

    public String getVersionString() {
        if (this.version == VERSION_2_5) {
            return "2.5";
        }
        if (this.version == VERSION_2_8) {
            return "2.8";
        }
        if (this.version == VERSION_2_8p) {
            return "2.8p";
        }
        if (this.version == VERSION_3_0p) {
            return "3.0p";
        }
        return "Unknown Version";
    }

    public int getBytesPerLine() {
        return this.bytesPerLine;
    }

    protected void setBytesPerLine(int bytesPerLine) {
        this.bytesPerLine = bytesPerLine;
    }

    public short getColorPlanes() {
        return this.colorPlanes;
    }

    protected void setColorPlanes(short colorPlanes) {
        this.colorPlanes = colorPlanes;
    }

    public short getDepth() {
        return this.depth;
    }

    protected void setDepth(short depth) {
        this.depth = depth;
    }

    public short getEncoding() {
        return this.encoding;
    }

    protected void setEncoding(short encoding) {
        this.encoding = encoding;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    public int getHres() {
        return this.hres;
    }

    protected void setHres(int hres) {
        this.hres = hres;
    }

    public short getManufacturer() {
        return this.manufacturer;
    }

    protected void setManufacturer(short manufacturer) {
        this.manufacturer = manufacturer;
    }

    public int getPaletteInfo() {
        return this.paletteInfo;
    }

    protected void setPaletteInfo(int paletteInfo) {
        this.paletteInfo = paletteInfo;
    }

    public short getReserved() {
        return this.reserved;
    }

    protected void setReserved(short reserved) {
        this.reserved = reserved;
    }

    public short getVersion() {
        return this.version;
    }

    protected void setVersion(short version) {
        this.version = version;
    }

    public int getVres() {
        return this.vres;
    }

    protected void setVres(int vres) {
        this.vres = vres;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public int getXmax() {
        return this.xmax;
    }

    protected void setXmax(int xmax) {
        this.xmax = xmax;
    }

    public int getXmin() {
        return this.xmin;
    }

    protected void setXmin(int xmin) {
        this.xmin = xmin;
    }

    public int getYmax() {
        return this.ymax;
    }

    protected void setYmax(int ymax) {
        this.ymax = ymax;
    }

    public int getYmin() {
        return this.ymin;
    }

    protected void setYmin(int ymin) {
        this.ymin = ymin;
    }

    public static class RGBTriple {
        private short red = 0;
        private short green = 0;
        private short blue = 0;

        public RGBTriple() {
        }

        public RGBTriple(int red, int green, int blue) {
            this((short)red, (short)green, (short)blue);
        }

        public RGBTriple(short red, short green, short blue) {
            this.setRed(red);
            this.setGreen(green);
            this.setBlue(blue);
        }

        public short getBlue() {
            return this.blue;
        }

        public void setBlue(short blue) {
            if (blue < 0 || blue > 255) {
                throw new IllegalArgumentException("value " + blue + " out of range 0...255!");
            }
            this.blue = blue;
        }

        public short getGreen() {
            return this.green;
        }

        public void setGreen(short green) {
            if (green < 0 || green > 255) {
                throw new IllegalArgumentException("value " + green + " out of range 0...255!");
            }
            this.green = green;
        }

        public short getRed() {
            return this.red;
        }

        public void setRed(short red) {
            if (red < 0 || red > 255) {
                throw new IllegalArgumentException("value " + red + " out of range 0...255!");
            }
            this.red = red;
        }
    }
}

