/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nightlabs.io.IOFilter;

public class IOFilterMan {
    protected List<IOFilter> ioFilters = new ArrayList<IOFilter>();
    protected Map<String, IOFilter> fileExtension2IOFilter = new HashMap<String, IOFilter>();

    public void addIOFilter(IOFilter ioFilter) {
        if (ioFilter == null) {
            throw new NullPointerException("Param ioFilter must not be null!");
        }
        this.ioFilters.add(ioFilter);
        int i = 0;
        while (i < ioFilter.getFileExtensions().length) {
            this.fileExtension2IOFilter.put(ioFilter.getFileExtensions()[i], ioFilter);
            ++i;
        }
    }

    public void removeIOFilter(IOFilter ioFilter) {
        if (this.ioFilters.contains(ioFilter)) {
            this.ioFilters.remove(ioFilter);
            int i = 0;
            while (i < ioFilter.getFileExtensions().length) {
                this.fileExtension2IOFilter.remove(ioFilter.getFileExtensions()[i]);
                ++i;
            }
        }
    }

    public IOFilter getIOFilter(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Param file must not be null!");
        }
        String fileExtension = this.getFileExtension(file);
        if (this.fileExtension2IOFilter.containsKey(fileExtension)) {
            return this.fileExtension2IOFilter.get(fileExtension);
        }
        return null;
    }

    public IOFilter getIOFilter(String fileExtension) {
        if (fileExtension == null) {
            throw new IllegalArgumentException("Param fileExtension must not be null!");
        }
        if (this.fileExtension2IOFilter.containsKey(fileExtension)) {
            return this.fileExtension2IOFilter.get(fileExtension);
        }
        return null;
    }

    protected String getFileExtension(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Param file must not be null!");
        }
        StringBuffer sb = new StringBuffer(file.getName());
        int index = sb.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return sb.substring(index + 1);
    }

    public Collection<IOFilter> getReadFilter() {
        HashSet<IOFilter> readFilter = new HashSet<IOFilter>();
        for (IOFilter ioFilter : this.ioFilters) {
            String[] stringArray = ioFilter.getFileExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExtension = stringArray[n2];
                if (ioFilter.supportsRead(fileExtension)) {
                    readFilter.add(ioFilter);
                }
                ++n2;
            }
        }
        return readFilter;
    }

    public Collection<IOFilter> getWriteFilter() {
        HashSet<IOFilter> writeFilter = new HashSet<IOFilter>();
        for (IOFilter ioFilter : this.ioFilters) {
            String[] stringArray = ioFilter.getFileExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExtension = stringArray[n2];
                if (ioFilter.supportsWrite(fileExtension)) {
                    writeFilter.add(ioFilter);
                }
                ++n2;
            }
        }
        return writeFilter;
    }

    public String[] getReadFileExtensions(boolean concatWildcard) {
        HashSet<String> readFileExtensions = new HashSet<String>();
        for (IOFilter ioFilter : this.ioFilters) {
            String[] stringArray = ioFilter.getFileExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExtension = stringArray[n2];
                if (ioFilter.supportsRead(fileExtension)) {
                    if (concatWildcard) {
                        readFileExtensions.add("*." + fileExtension);
                    } else {
                        readFileExtensions.add(fileExtension);
                    }
                }
                ++n2;
            }
        }
        return readFileExtensions.toArray(new String[readFileExtensions.size()]);
    }

    public String[] getWriteFileExtensions(boolean concatWildcard) {
        HashSet<String> readFileExtensions = new HashSet<String>();
        for (IOFilter ioFilter : this.ioFilters) {
            String[] stringArray = ioFilter.getFileExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExtension = stringArray[n2];
                if (ioFilter.supportsWrite(fileExtension)) {
                    if (concatWildcard) {
                        readFileExtensions.add("*." + fileExtension);
                    } else {
                        readFileExtensions.add(fileExtension);
                    }
                }
                ++n2;
            }
        }
        return readFileExtensions.toArray(new String[readFileExtensions.size()]);
    }
}

