/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.i18n;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class I18nText
implements Serializable {
    public static final String DEFAULT_LANGUAGEID = Locale.ENGLISH.getLanguage();

    protected abstract Map getI18nMap();

    public String getText() {
        return this.getText(Locale.getDefault().getLanguage());
    }

    protected abstract String getFallBackValue(String var1);

    private Map getEnsuredMap() {
        Map result = this.getI18nMap();
        if (result == null) {
            throw new IllegalStateException("Subclasses of I18nText must not return null in implementations of getI18nMap()!");
        }
        return result;
    }

    public String getText(String languageID) {
        Map map = this.getEnsuredMap();
        String result = (String)map.get(languageID);
        if (result == null) {
            result = (String)map.get(DEFAULT_LANGUAGEID);
        }
        if (result == null && !map.isEmpty()) {
            result = (String)map.values().iterator().next();
        }
        if (result == null) {
            result = this.getFallBackValue(languageID);
        }
        return result;
    }

    public void setText(String languageID, String text) {
        if ("".equals(text) || text == null) {
            this.getEnsuredMap().remove(languageID);
        } else {
            this.getEnsuredMap().put(languageID, text);
        }
    }

    public boolean isEmpty() {
        return this.getEnsuredMap().isEmpty();
    }

    public Set getTexts() {
        return this.getEnsuredMap().entrySet();
    }

    public Set getLanguageIDs() {
        return this.getEnsuredMap().keySet();
    }

    public void copyTo(I18nText other) {
        Map otherI18nMap = other.getI18nMap();
        otherI18nMap.clear();
        for (Map.Entry me : this.getEnsuredMap().entrySet()) {
            Object key = me.getKey();
            Object value = me.getValue();
            if (value == null) continue;
            otherI18nMap.put(key, value);
        }
    }

    public void copyFrom(I18nText other) {
        this.getEnsuredMap().clear();
        for (Map.Entry me : other.getI18nMap().entrySet()) {
            Object key = me.getKey();
            Object value = me.getValue();
            if (value == null) continue;
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("other's i18nMap contains a key which is an instance of " + key == null ? "null" : String.valueOf(key.getClass().getName()) + "! Must be String!");
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("other's i18nMap contains a value which is an instance of " + value.getClass().getName() + "! Must be String!");
            }
            this.getEnsuredMap().put(key, value);
        }
    }
}

