/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.eclipse.ui.pdfviewer;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.nightlabs.eclipse.ui.pdfviewer.AbstractPdfDocument;
import org.nightlabs.eclipse.ui.pdfviewer.Dimension2DDouble;
import org.nightlabs.eclipse.ui.pdfviewer.resource.Messages;

public class OneDimensionalPdfDocument
extends AbstractPdfDocument {
    private static final Logger logger = Logger.getLogger(OneDimensionalPdfDocument.class);
    private static final int MARGIN = 20;
    private Layout layout = Layout.vertical;
    private Dimension2DDouble documentDimension;
    private PDFFile pdfFile;
    private List<Rectangle2D.Double> pageBounds;

    public OneDimensionalPdfDocument() {
    }

    public OneDimensionalPdfDocument(PDFFile pdfFile, IProgressMonitor monitor) {
        this.initPdfFile(pdfFile, monitor);
    }

    public OneDimensionalPdfDocument(PDFFile pdfFile, Layout layout, IProgressMonitor monitor) {
        this.layout = layout;
        this.initPdfFile(pdfFile, monitor);
    }

    private void readPdf(IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("org.nightlabs.eclipse.ui.pdfviewer.OneDimensionalPdfDocument.readPdf.monitor.task.name"), this.pdfFile.getNumPages());
        try {
            this.documentDimension = new Dimension2DDouble(0.0, 0.0);
            this.pageBounds = new ArrayList<Rectangle2D.Double>(this.pdfFile == null ? 0 : this.pdfFile.getNumPages());
            if (this.pdfFile == null) {
                return;
            }
            switch (this.layout) {
                case vertical: {
                    double nextPageTop = 20.0;
                    int j = 0;
                    while (j < this.pdfFile.getNumPages()) {
                        PDFPage pdfPage = this.pdfFile.getPage(j + 1);
                        if (pdfPage == null) {
                            throw new IllegalStateException("pdfFile.getPage(...) returned null for page " + (j + 1) + "!");
                        }
                        if (pdfPage.getBBox() == null) {
                            throw new IllegalStateException("pdfFile.getPage(...).getBBox() returned null for page " + (j + 1) + "!");
                        }
                        double pdfPageWidth = pdfPage.getBBox().getWidth();
                        double pdfPageHeight = pdfPage.getBBox().getHeight();
                        if (this.documentDimension.getWidth() < pdfPageWidth) {
                            this.documentDimension.setWidth(pdfPageWidth);
                        }
                        this.pageBounds.add(new Rectangle2D.Double(0.0, nextPageTop, pdfPageWidth, pdfPageHeight));
                        nextPageTop += pdfPageHeight + 20.0;
                        monitor.worked(1);
                        ++j;
                    }
                    this.documentDimension.setHeight(nextPageTop);
                    this.documentDimension.setWidth(this.documentDimension.getWidth() + 40.0);
                    for (Rectangle2D.Double pageBound : this.pageBounds) {
                        pageBound.x = this.documentDimension.getWidth() / 2.0 - pageBound.width / 2.0;
                    }
                    break;
                }
                case horizontal: {
                    double nextPageLeft = 20.0;
                    int j = 0;
                    while (j < this.pdfFile.getNumPages()) {
                        PDFPage pdfPage = this.pdfFile.getPage(j + 1);
                        if (pdfPage == null) {
                            throw new IllegalStateException("pdfFile.getPage(...) returned null for page " + (j + 1) + "!");
                        }
                        if (pdfPage.getBBox() == null) {
                            throw new IllegalStateException("pdfFile.getPage(...).getBBox() returned null for page " + (j + 1) + "!");
                        }
                        double pdfPageWidth = pdfPage.getBBox().getWidth();
                        double pdfPageHeight = pdfPage.getBBox().getHeight();
                        if (this.documentDimension.getHeight() < pdfPageHeight) {
                            this.documentDimension.setHeight(pdfPageHeight);
                        }
                        this.pageBounds.add(new Rectangle2D.Double(nextPageLeft, 0.0, pdfPageWidth, pdfPageHeight));
                        nextPageLeft += pdfPageWidth + 20.0;
                        monitor.worked(1);
                        ++j;
                    }
                    this.documentDimension.setWidth(nextPageLeft);
                    this.documentDimension.setHeight(this.documentDimension.getHeight() + 40.0);
                    for (Rectangle2D.Double pageBound : this.pageBounds) {
                        pageBound.y = this.documentDimension.getHeight() / 2.0 - pageBound.height / 2.0;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown layout: " + (Object)((Object)this.layout));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Collection<Integer> getVisiblePages(Rectangle2D bounds) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int firstVisibleIdx = -1;
        int anyVisiblePage = this.findVisiblePage(bounds);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getVisiblePages: anyVisiblePage=" + anyVisiblePage));
        }
        if (anyVisiblePage < 0) {
            logger.warn((Object)"getVisiblePages: findVisiblePage(...) found none! Using expensive full scan!");
            int pageIdx = 0;
            while (pageIdx < this.pageBounds.size()) {
                if (this.isPageVisible(this.pageBounds.get(pageIdx), bounds)) {
                    firstVisibleIdx = pageIdx;
                    anyVisiblePage = firstVisibleIdx + 1;
                    break;
                }
                ++pageIdx;
            }
            if (anyVisiblePage < 0) {
                logger.warn((Object)"getVisiblePages: No page is visible!");
                return result;
            }
        } else {
            firstVisibleIdx = anyVisiblePage - 1;
            if (firstVisibleIdx > 0) {
                Rectangle2D.Double page = this.pageBounds.get(firstVisibleIdx - 1);
                while (page != null && (page.contains(bounds) || bounds.contains(page) || bounds.intersects(page))) {
                    Rectangle2D.Double double_ = page = --firstVisibleIdx - 1 < 0 ? null : this.pageBounds.get(firstVisibleIdx - 1);
                }
            }
        }
        int idx = firstVisibleIdx;
        Rectangle2D.Double page = this.pageBounds.get(idx);
        while (page != null && this.isPageVisible(page, bounds)) {
            result.add(++idx);
            Rectangle2D.Double double_ = page = idx < this.pageBounds.size() ? this.pageBounds.get(idx) : null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getVisiblePages: returning " + result.size() + " page numbers for bufferBounds=" + bounds));
            for (Integer pageNumber : result) {
                logger.debug((Object)("getVisiblePages: * " + pageNumber));
            }
        }
        return result;
    }

    private int findVisiblePage(Rectangle2D bounds) {
        int beginIdx = 0;
        int endIdx = this.pageBounds.size() - 1;
        if (this.isPageVisible(this.pageBounds.get(beginIdx), bounds)) {
            return beginIdx + 1;
        }
        if (this.isPageVisible(this.pageBounds.get(endIdx), bounds)) {
            return endIdx + 1;
        }
        int middleIdx = -1;
        while (endIdx - beginIdx > 1) {
            middleIdx = (beginIdx + endIdx) / 2;
            Rectangle2D.Double middlePage = this.pageBounds.get(middleIdx);
            if (this.isPageVisible(middlePage, bounds)) {
                return middleIdx + 1;
            }
            switch (this.layout) {
                case vertical: {
                    if (middlePage.getMinY() > bounds.getMaxY()) {
                        endIdx = middleIdx;
                        break;
                    }
                    beginIdx = middleIdx;
                    break;
                }
                case horizontal: {
                    if (middlePage.getMinX() > bounds.getMaxX()) {
                        endIdx = middleIdx;
                        break;
                    }
                    beginIdx = middleIdx;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown layout: " + (Object)((Object)this.layout));
                }
            }
        }
        if (middleIdx != beginIdx && this.isPageVisible(this.pageBounds.get(beginIdx), bounds)) {
            return beginIdx + 1;
        }
        if (middleIdx != endIdx && this.isPageVisible(this.pageBounds.get(endIdx), bounds)) {
            return endIdx + 1;
        }
        return -1;
    }

    private boolean isPageVisible(Rectangle2D page, Rectangle2D bounds) {
        return page.contains(bounds) || bounds.contains(page) || bounds.intersects(page);
    }

    @Override
    public Rectangle2D getPageBounds(int pageNumber) {
        return this.pageBounds.get(pageNumber - 1);
    }

    @Override
    public Dimension2D getDocumentDimension() {
        return this.documentDimension;
    }

    @Override
    public PDFFile getPdfFile() {
        return this.pdfFile;
    }

    @Override
    public void initPdfFile(PDFFile pdfFile, IProgressMonitor monitor) {
        if (this.pdfFile != null) {
            throw new IllegalStateException("A PDF file has already been assigned! This method cannot be called again!");
        }
        this.pdfFile = pdfFile;
        this.readPdf(monitor);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public static enum Layout {
        horizontal,
        vertical;

    }
}

