/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.LoggerTree;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LoggerTreeControl {
    private final TreeViewer v;
    private MyFilter myFilter;

    public LoggerTreeControl(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        this.v = new TreeViewer(tree);
        this.v.getTree().setLinesVisible(true);
        this.v.getTree().setHeaderVisible(true);
        TreeViewerColumn c1 = new TreeViewerColumn(this.v, 0);
        c1.getColumn().setWidth(200);
        c1.getColumn().setMoveable(false);
        c1.getColumn().setText("Name");
        c1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                LoggerTree.Node node = (LoggerTree.Node)element;
                return node.logger.getName();
            }
        });
        c1.getColumn().setData("minWidth", (Object)400);
        c1.getColumn().setData("maxWidth", (Object)400);
        TreeViewerColumn c2 = new TreeViewerColumn(this.v, 0);
        c2.getColumn().setWidth(200);
        c2.getColumn().setMoveable(false);
        c2.getColumn().setText("Level");
        c2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                LoggerTree.Node node = (LoggerTree.Node)element;
                return node.getLevel().getName();
            }
        });
        this.myFilter = new MyFilter();
        this.v.addFilter((ViewerFilter)this.myFilter);
        this.v.getTree().setMenu(this.createMenu());
        this.v.setContentProvider((IContentProvider)new LoggerContentProvider());
        this.v.setInput(this.getInput());
        UI.autoAdjustColumnWidthToContent(this.v.getTree());
    }

    public TreeViewer getTreeViewer() {
        return this.v;
    }

    private Object getInput() {
        return new Object[]{LoggerTree.getRootNode()};
    }

    private Menu createMenu() {
        Menu menu = new Menu((Control)this.v.getTree());
        MenuItem mexpand = new MenuItem(menu, 8);
        mexpand.setText("expand all");
        mexpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerTreeControl.this.expandAll();
            }
        });
        MenuItem mrefresh = new MenuItem(menu, 8);
        mrefresh.setText("refresh");
        mrefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerTreeControl.this.refresh();
            }
        });
        MenuItem msetLevel = new MenuItem(menu, 64);
        msetLevel.setText("set level");
        Menu submenu = new Menu(menu);
        msetLevel.setMenu(submenu);
        LoggerTree.ELevel[] eLevelArray = LoggerTree.ELevel.values();
        int n = eLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LoggerTree.ELevel elevel = eLevelArray[n2];
            MenuItem choiceLevel = new MenuItem(submenu, 8);
            choiceLevel.setData("elevel", (Object)elevel);
            choiceLevel.setText(elevel.toString());
            choiceLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem choiceItem = (MenuItem)e.getSource();
                    LoggerTree.ELevel eelevel = (LoggerTree.ELevel)((Object)choiceItem.getData("elevel"));
                    ITreeSelection selection = (ITreeSelection)LoggerTreeControl.this.v.getSelection();
                    if (!selection.isEmpty()) {
                        for (LoggerTree.Node node : selection) {
                            if (node.isRoot() && eelevel == LoggerTree.ELevel.NONE) continue;
                            node.logger.setLevel(eelevel.level);
                        }
                        LoggerTreeControl.this.v.refresh(true);
                    }
                }
            });
            ++n2;
        }
        return menu;
    }

    public void refresh() {
        this.v.setInput(this.getInput());
        UI.autoAdjustColumnWidthToContent(this.v.getTree());
    }

    private void expandAll() {
        this.expand(this.v.getTree().getItems());
    }

    private void expand(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setExpanded(true);
            this.expand(item.getItems());
            ++n2;
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final LoggerTreeControl vtree = new LoggerTreeControl((Composite)shell);
        Button button = new Button((Composite)shell, 8);
        button.setText("test selected logger");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerTree.Node node = (LoggerTree.Node)((ITreeSelection)vtree.v.getSelection()).getFirstElement();
                node.logger.severe("Test info with " + node.logger.getName());
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void filterByText(String containText) {
        this.myFilter.setContainText(containText);
        this.v.refresh();
        this.expandAll();
    }

    private static class LoggerContentProvider
    implements ITreeContentProvider {
        private LoggerTree.Node[] empy_array = new LoggerTree.Node[0];

        private LoggerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof LoggerTree.Node) {
                LoggerTree.Node node = (LoggerTree.Node)parentElement;
                return node.children.toArray();
            }
            return this.empy_array;
        }

        public Object getParent(Object element) {
            if (element instanceof LoggerTree.Node) {
                LoggerTree.Node node = (LoggerTree.Node)element;
                return node.parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            LoggerTree.Node node = (LoggerTree.Node)element;
            return !node.children.isEmpty();
        }
    }

    private static class MyFilter
    extends ViewerFilter {
        private String containText;

        private MyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.filter((LoggerTree.Node)element);
        }

        private boolean filter(LoggerTree.Node node) {
            if (this.containText == null || this.containText.trim().length() == 0) {
                return true;
            }
            if (node.toString().contains(this.containText)) {
                return true;
            }
            if (node.children.size() > 0) {
                for (LoggerTree.Node c : node.children) {
                    if (!this.filter(c)) continue;
                    return true;
                }
            }
            return false;
        }

        public void setContainText(String containText) {
            this.containText = containText;
        }
    }
}

