/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.ui.library.ResourceGetter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ResourceDialog {
    private static Shell resourceDialog;
    private static List tabColors;
    private static List tabImages;
    private static List tabFonts;
    private static List tabNotTracked;
    private static List tabOthers;
    private static Label lblColors;
    private static Label lblImages;
    private static Label lblFonts;
    private static Label lblNotTracked;
    private static Label lblNote;
    private static Label lblOthers;
    private static Label lblRequest;
    private static List tabRequest;
    private static ArrayList<Color> lstColors;
    private static ArrayList<Image> lstImages;
    private static ArrayList<Font> lstFonts;
    private static ArrayList<Object> lstNotTracked;
    private static ArrayList<WeakReference<Object>> lstOthers;

    static {
        lstColors = new ArrayList();
        lstImages = new ArrayList();
        lstFonts = new ArrayList();
        lstNotTracked = new ArrayList();
        lstOthers = new ArrayList();
    }

    public static void openResourceDialog(Shell parent) {
        if (resourceDialog == null || resourceDialog.isDisposed()) {
            resourceDialog = new Shell(parent, 1264);
            resourceDialog.setText("Resources Dialog");
            resourceDialog.setLayout((Layout)new FormLayout());
            lblNote = new Label((Composite)resourceDialog, 2112);
            Button btnRefresh = new Button((Composite)resourceDialog, 8);
            btnRefresh.setText("Refresh");
            SashForm sash = new SashForm((Composite)resourceDialog, 0);
            sash.setOrientation(512);
            Composite compColors = new Composite((Composite)sash, 0);
            compColors.setLayout((Layout)new FormLayout());
            Composite compImages = new Composite((Composite)sash, 0);
            compImages.setLayout((Layout)new FormLayout());
            Composite compFonts = new Composite((Composite)sash, 0);
            compFonts.setLayout((Layout)new FormLayout());
            Composite compNotTracked = new Composite((Composite)sash, 0);
            compNotTracked.setLayout((Layout)new FormLayout());
            Composite compOthers = new Composite((Composite)sash, 0);
            compOthers.setLayout((Layout)new FormLayout());
            tabColors = new List(compColors, 2560);
            tabImages = new List(compImages, 2560);
            tabFonts = new List(compFonts, 2560);
            tabNotTracked = new List(compNotTracked, 2560);
            tabOthers = new List(compOthers, 2560);
            lblColors = new Label(compColors, 2048);
            lblImages = new Label(compImages, 2048);
            lblFonts = new Label(compFonts, 2048);
            lblFonts.setText("Font");
            lblNotTracked = new Label(compNotTracked, 2048);
            lblOthers = new Label(compOthers, 2048);
            lblOthers.setText("Others");
            lblRequest = new Label((Composite)resourceDialog, 2048);
            tabRequest = new List((Composite)resourceDialog, 2560);
            tabColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ResourceDialog.colorSelected();
                }
            });
            tabImages.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ResourceDialog.imageSelected();
                }
            });
            tabFonts.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ResourceDialog.fontSelected();
                }
            });
            tabNotTracked.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ResourceDialog.notTrackedSelected();
                }
            });
            btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ResourceDialog.redrawResourceDialog();
                }
            });
            FormData data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            lblNote.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)lblNote);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            btnRefresh.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)btnRefresh);
            data.bottom = new FormAttachment((Control)lblRequest);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            sash.setLayoutData((Object)data);
            data = new FormData();
            data.bottom = new FormAttachment((Control)tabRequest);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            lblRequest.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(80);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            tabRequest.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(30);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            compColors.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(30);
            data.bottom = new FormAttachment(60);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            compImages.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(60);
            data.bottom = new FormAttachment(90);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            compFonts.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(90);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            compNotTracked.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(70);
            tabColors.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(70);
            tabImages.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(70);
            tabFonts.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(70);
            tabNotTracked.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            tabOthers.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(70);
            data.right = new FormAttachment(100);
            lblColors.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(70);
            data.right = new FormAttachment(100);
            lblImages.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(70);
            data.right = new FormAttachment(100);
            lblFonts.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(70);
            data.right = new FormAttachment(100);
            lblNotTracked.setLayoutData((Object)data);
            ResourceDialog.redrawResourceDialog();
            resourceDialog.pack();
            resourceDialog.setSize(270, Display.getDefault().getClientArea().height - 100);
            Rectangle clientArea = Display.getDefault().getClientArea();
            resourceDialog.setLocation(clientArea.width - ResourceDialog.resourceDialog.getSize().x, 0);
            resourceDialog.open();
        }
    }

    protected static void fontSelected() {
        if (tabFonts.getSelectionIndex() > -1) {
            lblFonts.setFont(lstFonts.get(tabFonts.getSelectionIndex()));
        }
    }

    protected static void imageSelected() {
        if (tabImages.getSelectionIndex() > -1) {
            lblImages.setImage(lstImages.get(tabImages.getSelectionIndex()));
        }
    }

    protected static void colorSelected() {
        if (tabColors.getSelectionIndex() > -1) {
            lblColors.setBackground(lstColors.get(tabColors.getSelectionIndex()));
        }
    }

    protected static void notTrackedSelected() {
        lblNotTracked.setText("");
        lblNotTracked.setBackground(null);
        lblNotTracked.setImage(null);
        if (tabNotTracked.getSelectionIndex() > -1 && Display.getDefault().getDeviceData().tracking) {
            Object resource = lstNotTracked.get(tabNotTracked.getSelectionIndex());
            if (resource instanceof Image) {
                if (!((Image)resource).isDisposed()) {
                    lblNotTracked.setImage((Image)resource);
                } else {
                    ResourceDialog.redrawResourceDialog();
                }
            } else if (resource instanceof Color) {
                if (!((Color)resource).isDisposed()) {
                    lblNotTracked.setBackground((Color)resource);
                } else {
                    ResourceDialog.redrawResourceDialog();
                }
            } else if (resource instanceof Font) {
                if (!((Font)resource).isDisposed()) {
                    lblNotTracked.setText("Font");
                    lblNotTracked.setFont((Font)resource);
                } else {
                    ResourceDialog.redrawResourceDialog();
                }
            }
        }
    }

    public static void redrawResourceDialog() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (resourceDialog != null && !resourceDialog.isDisposed()) {
                    tabRequest.removeAll();
                    tabColors.removeAll();
                    tabFonts.removeAll();
                    tabImages.removeAll();
                    tabNotTracked.removeAll();
                    tabOthers.removeAll();
                    lstColors.clear();
                    lstImages.clear();
                    lstFonts.clear();
                    lstNotTracked.clear();
                    lstOthers.clear();
                    Object[] allResources = Display.getDefault().getDeviceData().objects;
                    int j = 0;
                    while (j < allResources.length) {
                        lstNotTracked.add(allResources[j]);
                        ++j;
                    }
                    int nbResource = lstNotTracked.size();
                    for (ResourceGetter.Resource<Color> resource : ResourceGetter.getListColors()) {
                        tabColors.add(resource.object + " : " + resource.useCount);
                        lstColors.add((Color)resource.object);
                        lstNotTracked.remove(resource);
                    }
                    for (ResourceGetter.Resource<Color> resource : ResourceGetter.getListImages()) {
                        tabImages.add(resource.object + " : " + resource.useCount);
                        lstImages.add((Image)resource.object);
                        lstNotTracked.remove(resource);
                    }
                    for (ResourceGetter.Resource<Color> resource : ResourceGetter.getListFonts()) {
                        tabFonts.add(resource.object + " : " + resource.useCount);
                        lstFonts.add((Font)resource.object);
                        lstNotTracked.remove(resource);
                    }
                    int n = lstNotTracked.size();
                    int nbResourceTracked = lstFonts.size() + lstColors.size() + lstImages.size();
                    lblNote.setText("Resources : " + nbResource + ", Tracked : " + nbResourceTracked + ", Not Tracked : " + n);
                    Collections.sort(lstNotTracked, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return o1.toString().compareTo(o2.toString());
                        }
                    });
                    int j2 = 0;
                    while (j2 < lstNotTracked.size()) {
                        tabNotTracked.add(lstNotTracked.get(j2).toString());
                        ++j2;
                    }
                    if (!Display.getDefault().getDeviceData().tracking) {
                        tabNotTracked.add("The Display Is Not Tracking Resources");
                    }
                }
            }
        });
    }
}

