/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.cache;

import ca.infodata.ofys.ui.intro.cache.ICacheProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class CacheChecker {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.intro.cache.CacheChecker");
    private static final String CONTRIBUTION_ID = "ca.infodata.ofys.ui.intro.cacheprovider";
    private static CacheChecker instance;
    private Map<Class<?>, ICacheProvider<?>> contributes = new HashMap();

    private CacheChecker() {
        this.init();
    }

    public static CacheChecker getInstance() {
        if (instance == null) {
            instance = new CacheChecker();
        }
        return instance;
    }

    private void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTRIBUTION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object factory;
                String factoryClass = e.getAttribute("class");
                if (factoryClass != null && (factory = e.createExecutableExtension("class")) instanceof ICacheProvider) {
                    ICacheProvider provider = (ICacheProvider)factory;
                    this.contributes.put(provider.getProvideClass(), provider);
                }
            }
            catch (CoreException ex) {
                logger.log(Level.WARNING, "Failed to load prSubComposite " + e, ex);
            }
            ++n2;
        }
    }

    public ICacheProvider<?> getCacheProvider(Class<?> clazz) {
        return this.contributes.get(clazz);
    }
}

