/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.NoSessionException;
import ca.infodata.ofys.data.dataaccess.service.eform.EFormAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EFormFavCache
extends ObjectCache<XBaseEform> {
    private static final Logger logger = Logger.getLogger(EFormFavCache.class.getName());
    private static final String TAG = "fav";
    private boolean formsLoaded = false;
    private List<XBaseEform> lstSorted = null;
    private static final Comparator<XBaseEform> eformSortByName = new Comparator<XBaseEform>(){

        @Override
        public int compare(XBaseEform o1, XBaseEform o2) {
            return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
        }
    };

    protected EFormFavCache() {
        super(TAG);
    }

    public boolean isFormsLoaded() {
        return this.formsLoaded;
    }

    public void setFormsLoaded(boolean favoritesLoaded) {
        this.formsLoaded = favoritesLoaded;
    }

    public boolean contains(Integer id) {
        return this.getMap().containsKey(new ObjectCache.Key(TAG, id));
    }

    public XBaseEform getById(Integer id) {
        return this.getById(id, false);
    }

    private XBaseEform getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, false);
    }

    private XBaseEform getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseEform)this.get(new ObjectCache.Key(TAG, id), logIfNotFound, mustTryToFindServer);
    }

    public synchronized List<XBaseEform> getAll() {
        if (this.lstSorted == null) {
            this.lstSorted = new ArrayList<XBaseEform>();
            this.lstSorted.addAll(this.getMap().values());
            Collections.sort(this.lstSorted, eformSortByName);
        }
        return this.lstSorted;
    }

    public void put(Integer id, XBaseEform eform) {
        ObjectCache.Key key = new ObjectCache.Key(TAG, id);
        this.getMap().put(key, eform);
        this.lstSorted = null;
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        logger.info("EformController.loadFavorites()");
        try {
            if (session != null && session.getUser() != null && session.getUser().getId() != null) {
                EFormAccessorClient.getInstance().listFavorites(callback);
                this.lstSorted = null;
                this.formsLoaded = true;
            }
        }
        catch (NoSessionException noSessionException) {
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading eform list", e);
        }
    }

    public void add(XBaseEform e) {
        this.add((Map<ObjectCache.Key, XBaseEform>)this.getMap(), e);
        this.lstSorted = null;
    }

    public void remove(Integer idEform) {
        this.remove(new ObjectCache.Key(TAG, idEform));
        this.lstSorted = null;
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        logger.info("EformController.loadSync()");
        try {
            if (session != null && session.getUser() != null && session.getUser().getId() != null) {
                List list = EFormAccessorClient.getInstance().listFavorites();
                this.lstSorted = null;
                this.formsLoaded = true;
                callback.response(new ReturnObject((Serializable)((Object)list)));
            }
        }
        catch (NoSessionException noSessionException) {
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading eform list", e);
        }
    }

    protected void add(Map<ObjectCache.Key, XBaseEform> map, XBaseEform e) {
        if (e != null) {
            map.put(new ObjectCache.Key(TAG, e.getId()), e);
        }
    }

    protected XBaseEform loadSync(XSession session, ObjectCache.Key key) throws Exception {
        return null;
    }
}

