/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;

public final class DsqFormatter {
    public static String formatAuthor(IProvider p) {
        if (p == null) {
            return "";
        }
        if (p.getNIU_COLLEGE() == null) {
            return String.valueOf(p.getFirstName()) + " " + p.getLastName();
        }
        return String.valueOf(p.getFirstName()) + " " + p.getLastName() + "(" + p.getNIU_COLLEGE().value() + ")";
    }

    public static String formatLocation(ILocation location) {
        if (location == null) {
            return "";
        }
        JoinList list = new JoinList(", ");
        list.setTrim(true);
        list.add((CharSequence)DsqFormatter.nvl(location.getCode()));
        list.add((CharSequence)DsqFormatter.nvl(location.getName()));
        Address address = location.getAddress();
        if (address != null) {
            list.add((CharSequence)address.street);
            list.add((CharSequence)address.city);
            list.add((CharSequence)address.state);
            list.add((CharSequence)address.country);
            list.add((CharSequence)address.postalCode);
            list.add((CharSequence)address.telecom);
        }
        return list.toString();
    }

    public static String nvlt(Long s) {
        return s == null ? "" : DateUtil.ttoc((long)s);
    }

    public static String nvld(Long s) {
        return s == null ? "" : DateUtil.dtoc((long)s);
    }

    public static String nvlb(Boolean s) {
        return Boolean.TRUE.equals(s) ? "oui" : "non";
    }

    public static String nvl(Object s) {
        if (s instanceof String) {
            return DsqFormatter.nvl((String)s, "");
        }
        if (s instanceof Long) {
            return DsqFormatter.nvl((Long)s, "");
        }
        if (s == null) {
            return "";
        }
        return s.toString();
    }

    public static String nvl(String s, String df) {
        return s == null ? df : s;
    }

    public static String nvl(Long s, String df) {
        return s == null ? df : String.valueOf(df);
    }

    public static String formatCode(Code code) {
        if (code == null) {
            return "";
        }
        if (!StringUtils.isBlank((CharSequence)code.text)) {
            return code.text;
        }
        if (!StringUtils.isBlank((CharSequence)code.code)) {
            return code.code;
        }
        return "";
    }
}

