/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.IWebController;
import ca.infodata.ofys.client.web.controller.WebControllers;
import ca.infodata.ofys.ui.browser.sonar.ComponentLoader;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import ca.infodata.ofys.ui.dashboard.controller.LoginController;
import ca.infodata.ofys.util.IDisposeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;

public class WebComponents
implements IDisposeable {
    private final WebControllers webControllers;
    private final Map<String, IWebController> patternMapController;
    private final List<ComponentLoader> components;
    private final SonarDispatcher dispatcher;

    public WebComponents(BundleContext context, SonarDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.webControllers = new WebControllers();
        this.patternMapController = new HashMap<String, IWebController>();
        LoginController login = new LoginController();
        this.patternMapController.put("/j_security_check/login", (IWebController)login);
        this.patternMapController.put("/j_security_check/respAcceptance", (IWebController)login);
        this.patternMapController.put("/j_security_check/worksiteSelection", (IWebController)login);
        this.patternMapController.put("/j_security_check/loginfo", (IWebController)login);
        this.patternMapController.put("/dashboard/Login/ws/logout", (IWebController)login);
        this.patternMapController.put("/dashboard/Login/ws/isWeb", (IWebController)login);
        this.patternMapController.put("/dashboard/Login/ws/assist", (IWebController)login);
        this.patternMapController.put("/dashboard/Login/ws/saveConfigEmail", (IWebController)login);
        this.patternMapController.put("/dashboard/Login/ws/sendCodeToEmail", (IWebController)login);
        this.patternMapController.put("/login.html", (IWebController)login);
        if (Application.get().getGlobalInstances().getSession() != null) {
            this.patternMapController.put("/dashboard/Login/*", (IWebController)login);
            this.patternMapController.put("/dashboard", (IWebController)this.webControllers.getHomeController());
            this.patternMapController.put("/dashboard/debug/*", (IWebController)this.webControllers.getDebugController());
            this.patternMapController.put("/dashboard/User/*", (IWebController)this.webControllers.getUserController());
            this.patternMapController.put("/dashboard/Prof/*", (IWebController)this.webControllers.getProfessionalController());
            this.patternMapController.put("/dashboard/Complete/*", (IWebController)this.webControllers.getCompletionController());
            this.patternMapController.put("/dashboard/common/*", (IWebController)this.webControllers.getCommonController());
            this.patternMapController.put("/dashboard/apps/*", (IWebController)this.webControllers.getAppointmentController());
            this.patternMapController.put("/dashboard/ress/*", (IWebController)this.webControllers.getRessourceController());
            this.patternMapController.put("/dashboard/encs/*", (IWebController)this.webControllers.getEncounterController());
            this.patternMapController.put("/dashboard/template/*", (IWebController)this.webControllers.getTemplateAssistController());
            this.patternMapController.put("/dashboard/tasks/*", (IWebController)this.webControllers.getTaskController());
            this.patternMapController.put("/dashboard/courriel/*", (IWebController)this.webControllers.getCourrielController());
            this.patternMapController.put("/dashboard/docs/*", (IWebController)this.webControllers.getDocumentsController());
            this.patternMapController.put("/dashboard/forms/*", (IWebController)this.webControllers.getFormController());
            this.patternMapController.put("/dashboard/dsq/*", (IWebController)this.webControllers.getDsqController());
            this.patternMapController.put("/dashboard/crds/*", (IWebController)this.webControllers.getCrdsController());
            this.patternMapController.put("/dashboard/pref/*", (IWebController)this.webControllers.getPrefController());
            this.patternMapController.put("/dashboard/Labo/*", (IWebController)this.webControllers.getLaboratoryController());
            this.patternMapController.put("/dashboard/site/*", (IWebController)this.webControllers.getFacilityController());
            this.patternMapController.put("/dashboard/fax/*", (IWebController)this.webControllers.getFaxController());
            this.patternMapController.put("/dashboard/suiviprev/*", (IWebController)this.webControllers.getSuiviPrevController());
            this.patternMapController.put("/dashboard/ia/*", (IWebController)this.webControllers.getIaController());
            this.patternMapController.put("/dashboard/b2b/*", (IWebController)this.webControllers.getB2bController());
            this.patternMapController.put("/dashboard/Patients/*", (IWebController)this.webControllers.getPatientController());
            this.patternMapController.put("/dashboard/PatientSurvey/*", (IWebController)this.webControllers.getPatientSurveyController());
            this.patternMapController.put("/dashboard/print/*", (IWebController)this.webControllers.getPrintController());
            this.patternMapController.put("/dashboard/inspq/immunization/*", (IWebController)this.webControllers.getInspqImmunizationController());
            this.patternMapController.put("/dashboard/oauth/rtss/*", (IWebController)this.webControllers.getRtssoAuthController());
            this.patternMapController.put("/AuthorizationCallback/Ramq", (IWebController)this.webControllers.getRtssoAuthController());
            this.patternMapController.put("/AuthorizationCallback/Ramq/OfflineToken", (IWebController)this.webControllers.getRtssoAuthController());
        } else {
            this.patternMapController.put("/dashboard", (IWebController)login);
        }
        this.components = new ArrayList<ComponentLoader>(this.patternMapController.size());
        for (Map.Entry<String, IWebController> e : this.patternMapController.entrySet()) {
            String pattern = e.getKey();
            IWebController controller = e.getValue();
            this.components.add(new ComponentLoader(pattern, controller, context, "/dashboard"));
        }
        for (ComponentLoader c : this.components) {
            this.dispatcher.registerComponent(c);
        }
    }

    public WebControllers getWebControllers() {
        return this.webControllers;
    }

    public List<ComponentLoader> list() {
        return this.components;
    }

    public void dispose() throws Exception {
        this.webControllers.dispose();
        for (ComponentLoader c : this.components) {
            this.dispatcher.unregisterComponent(c);
        }
    }
}

