/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.jce.ProviderConfigurationPermission;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;

public class ProviderUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "ecImplicitlyCa");
    private static ThreadLocal threadSpec = new ThreadLocal();
    private static volatile org.bouncycastle.jce.spec.ECParameterSpec ecImplicitCaParams;

    static void setParameter(String parameterName, Object parameter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (parameterName.equals("threadLocalEcImplicitlyCa")) {
            org.bouncycastle.jce.spec.ECParameterSpec curveSpec;
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if ((curveSpec = parameter instanceof org.bouncycastle.jce.spec.ECParameterSpec || parameter == null ? (org.bouncycastle.jce.spec.ECParameterSpec)parameter : EC5Util.convertSpec((ECParameterSpec)parameter, false)) == null) {
                threadSpec.remove();
            } else {
                threadSpec.set(curveSpec);
            }
        } else if (parameterName.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            ecImplicitCaParams = parameter instanceof org.bouncycastle.jce.spec.ECParameterSpec || parameter == null ? (org.bouncycastle.jce.spec.ECParameterSpec)parameter : EC5Util.convertSpec((ECParameterSpec)parameter, false);
        }
    }

    public static org.bouncycastle.jce.spec.ECParameterSpec getEcImplicitlyCa() {
        org.bouncycastle.jce.spec.ECParameterSpec spec = (org.bouncycastle.jce.spec.ECParameterSpec)threadSpec.get();
        if (spec != null) {
            return spec;
        }
        return ecImplicitCaParams;
    }

    static int getReadLimit(InputStream in) throws IOException {
        if (in instanceof ByteArrayInputStream) {
            return in.available();
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }
}

