/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;

public abstract class CMSPBEKey
implements PBEKey {
    private char[] password;
    private byte[] salt;
    private int iterationCount;

    protected static PBEParameterSpec getParamSpec(AlgorithmParameters algParams) throws InvalidAlgorithmParameterException {
        try {
            return algParams.getParameterSpec(PBEParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException("cannot process PBE spec: " + e.getMessage());
        }
    }

    public CMSPBEKey(char[] password, byte[] salt, int iterationCount) {
        this.password = password;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    public CMSPBEKey(char[] password, PBEParameterSpec pbeSpec) {
        this(password, pbeSpec.getSalt(), pbeSpec.getIterationCount());
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public String getAlgorithm() {
        return "PKCS5S2";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    abstract byte[] getEncoded(String var1);
}

