/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.BulkOperationPacked;

final class BulkOperationPacked4
extends BulkOperationPacked {
    public BulkOperationPacked4() {
        super(4);
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        int i = 0;
        while (i < iterations) {
            long block = blocks[blocksOffset++];
            int shift = 60;
            while (shift >= 0) {
                values[valuesOffset++] = (int)(block >>> shift & 0xFL);
                shift -= 4;
            }
            ++i;
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, int[] values, int valuesOffset, int iterations) {
        int j = 0;
        while (j < iterations) {
            byte block = blocks[blocksOffset++];
            values[valuesOffset++] = block >>> 4 & 0xF;
            values[valuesOffset++] = block & 0xF;
            ++j;
        }
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        int i = 0;
        while (i < iterations) {
            long block = blocks[blocksOffset++];
            int shift = 60;
            while (shift >= 0) {
                values[valuesOffset++] = block >>> shift & 0xFL;
                shift -= 4;
            }
            ++i;
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, long[] values, int valuesOffset, int iterations) {
        int j = 0;
        while (j < iterations) {
            byte block = blocks[blocksOffset++];
            values[valuesOffset++] = block >>> 4 & 0xF;
            values[valuesOffset++] = block & 0xF;
            ++j;
        }
    }
}

