/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.Sorter;

public abstract class TimSorter
extends Sorter {
    static final int MINRUN = 32;
    static final int THRESHOLD = 64;
    static final int STACKSIZE = 40;
    static final int MIN_GALLOP = 7;
    final int maxTempSlots;
    int minRun;
    int to;
    int stackSize;
    int[] runEnds = new int[41];

    protected TimSorter(int maxTempSlots) {
        this.maxTempSlots = maxTempSlots;
    }

    static int minRun(int length) {
        assert (length >= 32);
        int n = length;
        int r = 0;
        while (n >= 64) {
            r |= n & 1;
            n >>>= 1;
        }
        int minRun = n + r;
        assert (minRun >= 32 && minRun <= 64);
        return minRun;
    }

    int runLen(int i) {
        int off = this.stackSize - i;
        return this.runEnds[off] - this.runEnds[off - 1];
    }

    int runBase(int i) {
        return this.runEnds[this.stackSize - i - 1];
    }

    int runEnd(int i) {
        return this.runEnds[this.stackSize - i];
    }

    void setRunEnd(int i, int runEnd) {
        this.runEnds[this.stackSize - i] = runEnd;
    }

    void pushRunLen(int len) {
        this.runEnds[this.stackSize + 1] = this.runEnds[this.stackSize] + len;
        ++this.stackSize;
    }

    /*
     * Unable to fully structure code
     */
    int nextRun() {
        block4: {
            runBase = this.runEnd(0);
            if (!TimSorter.$assertionsDisabled && runBase >= this.to) {
                throw new AssertionError();
            }
            if (runBase == this.to - 1) {
                return 1;
            }
            o = runBase + 2;
            if (this.compare(runBase, runBase + 1) <= 0) ** GOTO lbl14
            while (o < this.to && this.compare(o - 1, o) > 0) {
                ++o;
            }
            this.reverse(runBase, o);
            break block4;
lbl-1000:
            // 1 sources

            {
                ++o;
lbl14:
                // 2 sources

                ** while (o < this.to && this.compare((int)(o - 1), (int)o) <= 0)
            }
        }
        runHi = Math.max(o, Math.min(this.to, runBase + this.minRun));
        this.binarySort(runBase, runHi, o);
        return runHi - runBase;
    }

    void ensureInvariants() {
        while (this.stackSize > 1) {
            int runLen2;
            int runLen0 = this.runLen(0);
            int runLen1 = this.runLen(1);
            if (this.stackSize > 2 && (runLen2 = this.runLen(2)) <= runLen1 + runLen0) {
                if (runLen2 < runLen0) {
                    this.mergeAt(1);
                    continue;
                }
                this.mergeAt(0);
                continue;
            }
            if (runLen1 > runLen0) break;
            this.mergeAt(0);
        }
    }

    void exhaustStack() {
        while (this.stackSize > 1) {
            this.mergeAt(0);
        }
    }

    void reset(int from, int to) {
        this.stackSize = 0;
        Arrays.fill(this.runEnds, 0);
        this.runEnds[0] = from;
        this.to = to;
        int length = to - from;
        this.minRun = length <= 64 ? length : TimSorter.minRun(length);
    }

    void mergeAt(int n) {
        assert (this.stackSize >= 2);
        this.merge(this.runBase(n + 1), this.runBase(n), this.runEnd(n));
        int j = n + 1;
        while (j > 0) {
            this.setRunEnd(j, this.runEnd(j - 1));
            --j;
        }
        --this.stackSize;
    }

    void merge(int lo, int mid, int hi) {
        if (this.compare(mid - 1, mid) <= 0) {
            return;
        }
        lo = this.upper2(lo, mid, mid);
        if ((hi = this.lower2(mid, hi, mid - 1)) - mid <= mid - lo && hi - mid <= this.maxTempSlots) {
            this.mergeHi(lo, mid, hi);
        } else if (mid - lo <= this.maxTempSlots) {
            this.mergeLo(lo, mid, hi);
        } else {
            this.mergeInPlace(lo, mid, hi);
        }
    }

    @Override
    public void sort(int from, int to) {
        this.checkRange(from, to);
        if (to - from <= 1) {
            return;
        }
        this.reset(from, to);
        do {
            this.ensureInvariants();
            this.pushRunLen(this.nextRun());
        } while (this.runEnd(0) < to);
        this.exhaustStack();
        assert (this.runEnd(0) == to);
    }

    @Override
    void doRotate(int lo, int mid, int hi) {
        int len1 = mid - lo;
        int len2 = hi - mid;
        if (len1 == len2) {
            while (mid < hi) {
                this.swap(lo++, mid++);
            }
        } else if (len2 < len1 && len2 <= this.maxTempSlots) {
            this.save(mid, len2);
            int i = lo + len1 - 1;
            int j = hi - 1;
            while (i >= lo) {
                this.copy(i, j);
                --i;
                --j;
            }
            i = 0;
            j = lo;
            while (i < len2) {
                this.restore(i, j);
                ++i;
                ++j;
            }
        } else if (len1 <= this.maxTempSlots) {
            this.save(lo, len1);
            int i = mid;
            int j = lo;
            while (i < hi) {
                this.copy(i, j);
                ++i;
                ++j;
            }
            i = 0;
            j = lo + len2;
            while (j < hi) {
                this.restore(i, j);
                ++i;
                ++j;
            }
        } else {
            this.reverse(lo, mid);
            this.reverse(mid, hi);
            this.reverse(lo, hi);
        }
    }

    /*
     * Unable to fully structure code
     */
    void mergeLo(int lo, int mid, int hi) {
        if (!TimSorter.$assertionsDisabled && this.compare(lo, mid) <= 0) {
            throw new AssertionError();
        }
        len1 = mid - lo;
        this.save(lo, len1);
        this.copy(mid, lo);
        i = 0;
        j = mid + 1;
        dest = lo + 1;
        while (true) {
            count = 0;
            while (count < 7) {
                if (i < len1 && j < hi) {
                    if (this.compareSaved(i, j) <= 0) {
                        this.restore(i++, dest++);
                        count = 0;
                        continue;
                    }
                    this.copy(j++, dest++);
                    ++count;
                    continue;
                }
                ** GOTO lbl30
            }
            next = this.lowerSaved3(j, hi, i);
            while (j < next) {
                this.copy(j++, dest);
                ++dest;
            }
            this.restore(i++, dest++);
        }
lbl-1000:
        // 1 sources

        {
            this.restore(i++, dest);
            ++dest;
lbl30:
            // 2 sources

            ** while (i < len1)
        }
lbl31:
        // 1 sources

        if (!TimSorter.$assertionsDisabled && j != dest) {
            throw new AssertionError();
        }
    }

    /*
     * Unable to fully structure code
     */
    void mergeHi(int lo, int mid, int hi) {
        if (!TimSorter.$assertionsDisabled && this.compare(mid - 1, hi - 1) <= 0) {
            throw new AssertionError();
        }
        len2 = hi - mid;
        this.save(mid, len2);
        this.copy(mid - 1, hi - 1);
        i = mid - 2;
        j = len2 - 1;
        dest = hi - 2;
        while (true) {
            count = 0;
            while (count < 7) {
                if (i >= lo && j >= 0) {
                    if (this.compareSaved(j, i) >= 0) {
                        this.restore(j--, dest--);
                        count = 0;
                        continue;
                    }
                    this.copy(i--, dest--);
                    ++count;
                    continue;
                }
                ** GOTO lbl29
            }
            next = this.upperSaved3(lo, i + 1, j);
            while (i >= next) {
                this.copy(i--, dest--);
            }
            this.restore(j--, dest--);
        }
lbl-1000:
        // 1 sources

        {
            this.restore(j--, dest);
            --dest;
lbl29:
            // 2 sources

            ** while (j >= 0)
        }
lbl30:
        // 1 sources

        if (!TimSorter.$assertionsDisabled && i != dest) {
            throw new AssertionError();
        }
    }

    int lowerSaved(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from + half;
            if (this.compareSaved(val, mid) > 0) {
                from = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    int upperSaved(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from + half;
            if (this.compareSaved(val, mid) < 0) {
                len = half;
                continue;
            }
            from = mid + 1;
            len = len - half - 1;
        }
        return from;
    }

    int lowerSaved3(int from, int to, int val) {
        int f = from;
        int t = f + 1;
        while (t < to) {
            if (this.compareSaved(val, t) <= 0) {
                return this.lowerSaved(f, t, val);
            }
            int delta = t - f;
            f = t;
            t += delta << 1;
        }
        return this.lowerSaved(f, to, val);
    }

    int upperSaved3(int from, int to, int val) {
        int f = to - 1;
        int t = to;
        while (f > from) {
            if (this.compareSaved(val, f) >= 0) {
                return this.upperSaved(f, t, val);
            }
            int delta = t - f;
            t = f;
            f -= delta << 1;
        }
        return this.upperSaved(from, t, val);
    }

    protected abstract void copy(int var1, int var2);

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    protected abstract int compareSaved(int var1, int var2);
}

