/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Comparator;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IOUtils;

public class PlainTextDictionary
implements Dictionary {
    private BufferedReader in;

    public PlainTextDictionary(File file) throws IOException {
        this.in = new BufferedReader(IOUtils.getDecodingReader(file, IOUtils.CHARSET_UTF_8));
    }

    public PlainTextDictionary(InputStream dictFile) {
        this.in = new BufferedReader(IOUtils.getDecodingReader(dictFile, IOUtils.CHARSET_UTF_8));
    }

    public PlainTextDictionary(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    @Override
    public BytesRefIterator getWordsIterator() throws IOException {
        return new FileIterator();
    }

    final class FileIterator
    implements BytesRefIterator {
        private boolean done = false;
        private final BytesRef spare = new BytesRef();

        FileIterator() {
        }

        @Override
        public BytesRef next() throws IOException {
            BytesRef result;
            if (this.done) {
                return null;
            }
            boolean success = false;
            try {
                String line = PlainTextDictionary.this.in.readLine();
                if (line != null) {
                    this.spare.copyChars(line);
                    result = this.spare;
                } else {
                    this.done = true;
                    IOUtils.close(PlainTextDictionary.this.in);
                    result = null;
                }
                success = true;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(PlainTextDictionary.this.in);
                }
                throw throwable;
            }
            if (!success) {
                IOUtils.closeWhileHandlingException(PlainTextDictionary.this.in);
            }
            return result;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return null;
        }
    }
}

