/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.wizard;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MyProgressMonitorPart
extends FontAwareComposite
implements IProgressMonitorWithBlocking {
    protected FontAwareLabel fLabel;
    protected String fTaskName;
    protected String fSubTaskName;
    protected ProgressIndicator fProgressIndicator;
    protected Control fCancelComponent;
    protected volatile boolean fIsCanceled;
    protected org.eclipse.core.runtime.IStatus blockedStatus;
    protected Listener fCancelListener = new Listener(){

        public void handleEvent(Event e) {
            MyProgressMonitorPart.this.setCanceled(true);
            if (MyProgressMonitorPart.this.fCancelComponent != null && !MyProgressMonitorPart.this.fCancelComponent.isDisposed()) {
                MyProgressMonitorPart.this.fCancelComponent.setEnabled(false);
            }
        }
    };
    private Button fStopButton;
    private boolean fHasStopButton = false;
    private Color fLabelOriginalForeground;
    private Color fLabelRedForeground;

    public MyProgressMonitorPart(Composite parent, Layout layout) {
        this(parent, layout, false);
    }

    public MyProgressMonitorPart(Composite parent, Layout layout, int progressIndicatorHeight) {
        super(parent, 2048);
        this.initialize(layout, progressIndicatorHeight);
    }

    public MyProgressMonitorPart(Composite parent, Layout layout, boolean createStopButton) {
        super(parent, 2048);
        this.fHasStopButton = createStopButton;
        this.initialize(layout, -1);
    }

    public MyProgressMonitorPart(Composite parent, Layout layout, boolean createStopButton, int progressIndicatorHeight) {
        super(parent, 2048);
        this.fHasStopButton = createStopButton;
        this.initialize(layout, progressIndicatorHeight);
    }

    public void attachToCancelComponent(Control cancelComponent) {
        if (this.fHasStopButton) {
            this.setCancelEnabled(true);
        } else {
            this.fCancelComponent = cancelComponent;
            this.fCancelComponent.addListener(13, this.fCancelListener);
        }
    }

    public void beginTask(String name, int totalWork) {
        this.fTaskName = name;
        this.fSubTaskName = "";
        this.updateLabel();
        if (totalWork == -1 || totalWork == 0) {
            this.fProgressIndicator.beginAnimatedTask();
        } else {
            this.fProgressIndicator.beginTask(totalWork);
        }
        if (this.fStopButton != null && !this.fStopButton.isDisposed()) {
            this.fStopButton.setVisible(true);
            this.fStopButton.setFocus();
        }
    }

    public void done() {
        if (!this.isDisposed()) {
            this.fLabel.setText("");
            this.fSubTaskName = "";
            this.fProgressIndicator.sendRemainingWork();
            this.fProgressIndicator.done();
            if (this.fStopButton != null && !this.fStopButton.isDisposed()) {
                this.fStopButton.setVisible(false);
            }
        }
    }

    protected static String escapeMetaCharacters(String in) {
        if (in == null || in.indexOf(38) < 0) {
            return in;
        }
        int length = in.length();
        StringBuffer out = new StringBuffer(length + 1);
        int i = 0;
        while (i < length) {
            char c = in.charAt(i);
            if (c == '&') {
                out.append("&&");
            } else {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    protected void initialize(Layout layout, int progressIndicatorHeight) {
        if (layout == null) {
            GridLayout l = new GridLayout();
            l.marginWidth = 0;
            l.marginHeight = 0;
            layout = l;
        }
        int numColumns = 1;
        if (this.fHasStopButton) {
            ++numColumns;
        }
        this.setLayout(layout);
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).numColumns = numColumns;
        }
        this.fLabel = new FontAwareLabel(this, 16384);
        this.fLabel.setLayoutData(new GridData(4, 2, true, false, numColumns, 1));
        this.fLabelOriginalForeground = this.fLabel.getForeground();
        this.fLabelRedForeground = ResourceGetter.getRedWarningColor();
        this.fProgressIndicator = new ProgressIndicator((Composite)this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.verticalAlignment = 2;
        gd.heightHint = progressIndicatorHeight;
        this.fProgressIndicator.setLayoutData((Object)gd);
        if (this.fHasStopButton) {
            this.fStopButton = new FontAwareButton(this, 8);
            this.fStopButton.setText(Messages.getString((String)"ANNULER", (String[])new String[0]));
            gd = new GridData();
            gd.verticalAlignment = 2;
            this.fStopButton.setLayoutData((Object)gd);
            this.fStopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MyProgressMonitorPart.this.setCanceled(true);
                    if (MyProgressMonitorPart.this.fStopButton != null) {
                        MyProgressMonitorPart.this.fStopButton.setEnabled(false);
                    }
                }
            });
            this.fStopButton.setEnabled(false);
        }
    }

    public void internalWorked(double work) {
        this.fProgressIndicator.worked(work);
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public void removeFromCancelComponent(Control cancelComponent) {
        if (this.fHasStopButton) {
            this.setCancelEnabled(false);
        } else {
            Assert.isTrue((this.fCancelComponent == cancelComponent && this.fCancelComponent != null ? 1 : 0) != 0);
            this.fCancelComponent.removeListener(13, this.fCancelListener);
            this.fCancelComponent = null;
        }
    }

    public void setCanceled(boolean b) {
        this.fIsCanceled = b;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fLabel != null) {
            this.fLabel.setFont(font);
        }
        if (this.fProgressIndicator != null) {
            this.fProgressIndicator.setFont(font);
        }
    }

    public void setTaskName(String name) {
        this.fTaskName = name;
        this.updateLabel();
    }

    public void subTask(String name) {
        this.fSubTaskName = name;
        this.updateLabel();
    }

    protected void updateLabel() {
        if (!this.isDisposed()) {
            this.fLabel.setForeground(this.fLabelOriginalForeground);
            if (this.blockedStatus == null) {
                String text = this.taskLabel();
                this.fLabel.setText(text);
            } else {
                this.fLabel.setText(this.blockedStatus.getMessage());
            }
            this.fLabel.update();
        }
    }

    private String taskLabel() {
        boolean hasSubtask;
        boolean hasTask = this.fTaskName != null && this.fTaskName.length() > 0;
        boolean bl = hasSubtask = this.fSubTaskName != null && this.fSubTaskName.length() > 0;
        if (hasTask) {
            if (hasSubtask) {
                return MyProgressMonitorPart.escapeMetaCharacters(JFaceResources.format((String)"Set_SubTask", (Object[])new Object[]{this.fTaskName, this.fSubTaskName}));
            }
            return MyProgressMonitorPart.escapeMetaCharacters(this.fTaskName);
        }
        if (hasSubtask) {
            return MyProgressMonitorPart.escapeMetaCharacters(this.fSubTaskName);
        }
        return "";
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public void clearBlocked() {
        this.blockedStatus = null;
        this.updateLabel();
    }

    public void setBlocked(org.eclipse.core.runtime.IStatus reason) {
        this.blockedStatus = reason;
        this.updateLabel();
    }

    private void setCancelEnabled(boolean enabled) {
        if (this.fStopButton != null && !this.fStopButton.isDisposed()) {
            this.fStopButton.setEnabled(enabled);
            if (enabled) {
                this.fStopButton.setFocus();
            }
        }
    }

    public void setException(Throwable e) {
        if (!this.isDisposed() && e != null) {
            this.fLabel.setForeground(ResourceGetter.getRedWarningColor());
            this.fLabel.setText(this.getMessageForException(e));
        }
    }

    public void setStatus(IStatus status) {
        if (!this.isDisposed() && status != null) {
            this.getMessageFromStatus(status);
            boolean notBlank = StringUtils.isNotBlank((String)status.getMessage());
            if (status.isOK() && notBlank) {
                this.fLabel.setForeground(this.fLabelOriginalForeground);
                this.fLabel.setText(status.getMessage());
            } else if (status.isLessSevereThan(IStatus.Severity.ERROR) && notBlank) {
                this.fLabel.setForeground(this.fLabelOriginalForeground);
                this.fLabel.setText(status.getMessage());
            } else if (status.getException() != null) {
                this.fLabel.setForeground(this.fLabelRedForeground);
                this.fLabel.setText(new JoinList("\r\n", new Object[]{status.getMessage(), this.getMessageForException(status.getException())}).toString());
            } else if (notBlank) {
                this.fLabel.setForeground(this.fLabelRedForeground);
                this.fLabel.setText(status.getMessage());
            }
        }
    }

    private String getMessageForException(Throwable e) {
        if (e == null) {
            return null;
        }
        String text = StringUtils.isNotBlank((String)e.getMessage()) ? e.getMessage() : e.getClass().getName();
        return text;
    }

    private String getMessageFromStatus(IStatus status) {
        List<IStatus> list = status instanceof MultiStatus ? ((MultiStatus)status).getFlattenedNonOKChildren() : Arrays.asList(status);
        JoinList message = new JoinList("\n");
        for (IStatus s : list) {
            message.add((CharSequence)s.getMessage());
        }
        return list.toString();
    }
}

