/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.util;

import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.ofys.ui.controls.util.UserDialogSettings3;
import ca.infodata.ofys.ui.library.LibPlugin;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MyDialogSettings
extends UserDialogSettings3 {
    private static final Logger logger = Logger.getLogger(MyDialogSettings.class.getName());
    private String dsPath = null;
    private boolean isLoaded = false;

    public static void tryDeleteSettingFile(String fileName) {
        if (fileName != null) {
            try {
                File file = new File(String.valueOf(LibPlugin.OFYS_HOME) + fileName);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Failed to delete " + fileName + " settings file ", e);
            }
        }
    }

    public MyDialogSettings(String fileName, String section) {
        super(section);
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cant be null");
        }
        this.dsPath = String.valueOf(LibPlugin.OFYS_HOME) + fileName;
        if (new File(this.dsPath).exists()) {
            this.load();
        } else {
            this.setDefaultValues();
            this.save();
        }
    }

    public String getPath() {
        return this.dsPath;
    }

    public void save() {
        try {
            this.save(this.dsPath);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Erreur on saving dialogSettings", e);
        }
    }

    public void load() {
        if (!this.isLoaded) {
            try {
                this.load(this.dsPath);
                this.isLoaded = true;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Erreur on loading dialogSettings", e);
            }
        }
    }

    public void setIsLoaded(boolean value) {
        this.isLoaded = value;
    }

    public IDialogSettings3 getOrCreateSection(String sectionName) {
        IDialogSettings3 section = this.getSection(sectionName);
        if (section == null) {
            section = this.addNewSection(sectionName);
        }
        return section;
    }

    public void setDefaultValues() {
    }
}

