/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.textAssistant;

import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InformationPopup {
    private Shell shell;
    private Shell parent;
    private Shell brotherPopup;
    private Text label;

    public InformationPopup(Shell parent, Shell brotherPopup, int width) {
        this.parent = parent;
        this.brotherPopup = brotherPopup;
        this.createControl(width);
    }

    private void createControl(int width) {
        this.shell = new Shell(this.parent, 2048);
        this.label = new Text((Composite)this.shell, 0x800308);
        Color yellowColor = ResourceGetter.getColor((int)255, (int)255, (int)225);
        Color mediumGreyColor = ResourceGetter.getColor((int)112, (int)112, (int)99);
        this.shell.setBackground(mediumGreyColor);
        this.label.setBackground(yellowColor);
        this.brotherPopup.getSize();
        FormLayout layout = new FormLayout();
        layout.marginBottom = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.marginRight = 1;
        layout.spacing = 1;
        this.shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        data.width = width - 2;
        this.label.setLayoutData((Object)data);
        this.hide();
        this.shell.pack();
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (InformationPopup.this.brotherPopup != null && !InformationPopup.this.brotherPopup.isDisposed()) {
                    InformationPopup.this.brotherPopup.close();
                }
            }
        });
    }

    private void hide() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.setVisible(false);
        }
    }

    private void show() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.setVisible(true);
            Rectangle broBounds = this.brotherPopup.getBounds();
            System.out.println("WIDTH OF BRO :" + broBounds.width);
            this.shell.setBounds(broBounds.x + broBounds.width, broBounds.y, broBounds.width, broBounds.height);
        }
    }

    public void setText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            this.hide();
        } else {
            this.label.setText(text);
            this.show();
        }
    }

    public Shell getPopup() {
        return this.shell;
    }

    public boolean isDisposed() {
        return this.shell == null || this.shell.isDisposed();
    }
}

