/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.client.modules.template.DDate;
import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.util1.StringUtils;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DDateDialog
extends MyMessageDialogBuilder {
    private static String REQUIRED_DATA = Messages.getString((String)"REQUIRED_DATA", (String[])new String[0]);
    private DDate field;
    private MyMaskedText txtText;
    private MyButton chkAllowPast;
    private MyButton chkAllowFuture;
    private MyButton chkTodayAuto;
    private MyButton chkRequired;
    private final XCompletionProposalType type;

    public DDateDialog(Shell shell, DDate field, XCompletionProposalType xType) {
        this.field = field;
        this.type = xType;
        this.setButtonLabels(Messages.getString((String)"OK", (String[])new String[0]), Messages.getString((String)"CANCEL", (String[])new String[0]));
        this.setDefaultButton(-1);
        this.setParent(shell);
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        parent = new Composite(parent, 0);
        RowLayout layout = new RowLayout(512);
        layout.fill = true;
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        new MyLabel(parent, "Nom : ", 16384);
        this.txtText = new MyMaskedText(parent, Pattern.compile(DField.regExpForName));
        this.txtText.setValidStyle(6);
        this.chkAllowPast = new MyButton(parent, "Permettre les dates pass\u00e9es", 32, null);
        this.chkAllowFuture = new MyButton(parent, "Permettre les dates futures", 32, null);
        this.chkTodayAuto = new MyButton(parent, "Mettre la date du jour automatiquement", 32, null);
        this.chkRequired = new MyButton(parent, REQUIRED_DATA, 32, null);
        this.setTitle("Texte");
        this.txtText.setText(StringUtils.defaultString((String)this.field.name));
        this.chkAllowPast.setSelection(this.field.allowPast == null ? true : this.field.allowPast);
        this.chkAllowFuture.setSelection(this.field.allowFuture == null ? true : this.field.allowFuture);
        this.chkTodayAuto.setSelection(this.field.todayAuto == null ? false : this.field.todayAuto);
        this.chkRequired.setSelection(this.field.required);
        return parent;
    }

    @Override
    protected boolean customShouldTakeFocus() {
        return true;
    }

    @Override
    protected boolean buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.txtText.getText().trim();
            if (StringUtils.isBlank((CharSequence)name)) {
                return false;
            }
            this.field.name = name;
            this.field.allowPast = new Boolean(this.chkAllowPast.getSelection());
            this.field.allowFuture = new Boolean(this.chkAllowFuture.getSelection());
            this.field.todayAuto = new Boolean(this.chkTodayAuto.getSelection());
            this.field.required = new Boolean(this.chkRequired.getSelection());
        }
        return true;
    }
}

