/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.ui.controls.MyEmptySelection;
import ca.infodata.ofys.ui.controls.MySelection;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.ofys.ui.controls.report2.PrintTreeContentProvider;
import ca.infodata.ofys.ui.controls.report2.PrintTreeLabelAndCheckedStateProvider;
import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PrintTree {
    protected static final String EXPANDED = "EXPANDED";
    private CheckboxTreeViewer treeViewer;
    private PrintTreeContentProvider contentProvider = new PrintTreeContentProvider();
    private PrintTreeLabelAndCheckedStateProvider labelProvider;
    private PrintController controller;

    public PrintTree(Composite parent, int style, FormToolkit toolkit) {
        this.treeViewer = new CheckboxTreeViewer(toolkit.createTree(parent, 32)){

            protected void handleDoubleSelect(SelectionEvent event) {
            }
        };
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean state = event.getChecked();
                Object element = event.getElement();
                if (element instanceof PrintTreeContentProvider.ReportItem) {
                    PrintTree.this.treeViewer.setSelection(new MySelection<Object>(element));
                    PrintTreeContentProvider.ReportItem reportItem = (PrintTreeContentProvider.ReportItem)element;
                    IReport report = ((PrintTreeContentProvider.ReportItem)element).report;
                    if (state) {
                        PrintTree.this.controller.getSelection().add(report);
                    } else {
                        PrintTree.this.controller.getSelection().remove(report);
                    }
                    PrintTree.this.treeViewer.refresh((Object)reportItem, false);
                    PrintTree.this.treeViewer.refresh((Object)reportItem.categoryItem, true);
                    PrintTree.this.controller.savePreferences(report, null);
                } else if (element instanceof PrintTreeContentProvider.CategoryItem) {
                    IReport report;
                    PrintTree.this.treeViewer.setSelection(new MyEmptySelection());
                    PrintTreeContentProvider.CategoryItem categoryItem = (PrintTreeContentProvider.CategoryItem)element;
                    ArrayList<IReport> reports = new ArrayList<IReport>();
                    if (state) {
                        for (PrintTreeContentProvider.ReportItem reportItem : categoryItem.children) {
                            report = reportItem.report;
                            PrintTree.this.controller.getSelection().add(report);
                            reports.add(report);
                        }
                    } else {
                        for (PrintTreeContentProvider.ReportItem reportItem : categoryItem.children) {
                            report = reportItem.report;
                            PrintTree.this.controller.getSelection().remove(report);
                            reports.add(report);
                        }
                    }
                    for (PrintTreeContentProvider.ReportItem r : categoryItem.children) {
                        PrintTree.this.treeViewer.refresh((Object)r, false);
                    }
                    PrintTree.this.treeViewer.refresh(element, true);
                    PrintTree.this.controller.savePreferences(reports);
                }
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.getTree().setFont(ResourceGetter.getFontNormal());
        this.labelProvider = new PrintTreeLabelAndCheckedStateProvider(this.treeViewer);
        TreeViewerColumn c5 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        c5.getColumn().setWidth(400);
        c5.getColumn().setText("Rapports d'impression");
        c5.setLabelProvider((CellLabelProvider)this.labelProvider);
        this.treeViewer.setCheckStateProvider((ICheckStateProvider)this.labelProvider);
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                PrintTree.this.saveCategoryItemExpandStatePreference(event.getElement(), true);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                PrintTree.this.saveCategoryItemExpandStatePreference(event.getElement(), false);
            }
        });
    }

    protected void saveCategoryItemExpandStatePreference(Object element, boolean expanded) {
        if (element instanceof PrintTreeContentProvider.CategoryItem) {
            PrintTreeContentProvider.CategoryItem categoryItem = (PrintTreeContentProvider.CategoryItem)element;
            IDialogSettings3 section = this.controller.getPreferences(categoryItem.category);
            section.put(EXPANDED, expanded);
            this.controller.savePreferences();
        }
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public PrintController getController() {
        return this.controller;
    }

    public void setController(PrintController controller) {
        this.controller = controller;
        this.labelProvider.setController(controller);
        this.treeViewer.setInput((Object)controller);
        this.applyCategoryExpandStatePreferences();
    }

    private void applyCategoryExpandStatePreferences() {
        ArrayList<PrintTreeContentProvider.CategoryItem> expandedElements = new ArrayList<PrintTreeContentProvider.CategoryItem>();
        List<PrintTreeContentProvider.CategoryItem> elements = this.contentProvider.getElements2(this.controller);
        if (elements != null) {
            for (PrintTreeContentProvider.CategoryItem categoryItem : elements) {
                IDialogSettings3 section = this.controller.getPreferences(categoryItem.category);
                boolean expanded = true;
                if (section != null) {
                    expanded = section.getBoolean(EXPANDED, true);
                }
                if (!expanded) continue;
                expandedElements.add(categoryItem);
            }
        }
        this.treeViewer.setExpandedElements(expandedElements.toArray());
    }

    public void setSelectionByReportId(String reportId) {
        PrintTreeContentProvider.ReportItem item;
        if (StringUtils.isNotBlank((String)reportId) && (item = this.contentProvider.findReportItemByReportId(reportId)) != null) {
            this.treeViewer.setSelection(new MySelection<PrintTreeContentProvider.ReportItem>(item), false);
        }
    }
}

