/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.grid;

import ca.infodata.ofys.ui.controls.grid.SelectionListener;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.TruePredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class Selection<T>
extends TreeSet<T> {
    private static final long serialVersionUID = 1L;
    private T lastSelectedItem;
    private int hashCode;
    private PredicateA<T> selectionPredicate;
    public T dragStartItem;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private boolean isDisposed;

    public void addAndFinalize(T o) {
        this.assertIsNotDisPosed();
        this.add(o);
        this.finalizeSelection();
    }

    public void addAllAndFinalize(Collection<? extends T> c) {
        this.assertIsNotDisPosed();
        this.addAll(c);
        this.finalizeSelection();
    }

    public void clearAddAndFinalize(T o) {
        this.assertIsNotDisPosed();
        this.clear();
        this.add(o);
        this.finalizeSelection();
    }

    public void clearAddAllAndFinalize(Collection<? extends T> c) {
        this.assertIsNotDisPosed();
        this.clear();
        this.addAll(c);
        this.finalizeSelection();
    }

    @Override
    public boolean add(T o) {
        this.assertIsNotDisPosed();
        this.checkAgainstNull(o);
        this.dragStartItem = null;
        boolean add = false;
        if (this.getSelectionPredicate().evaluate(o)) {
            add = super.add(o);
            this.lastSelectedItem = o;
        }
        return add;
    }

    private void checkAgainstNull(Object o) {
        this.assertIsNotDisPosed();
        if (o == null) {
            throw new IllegalArgumentException("item cant be null");
        }
    }

    @Override
    public void clear() {
        this.assertIsNotDisPosed();
        this.lastSelectedItem = null;
        this.dragStartItem = null;
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.assertIsNotDisPosed();
        this.dragStartItem = null;
        boolean add = false;
        boolean first = true;
        for (T t : c) {
            if (first) {
                this.lastSelectedItem = t;
                first = false;
            }
            boolean bl = add = this.add(t) || add;
        }
        return add;
    }

    public void track(T item) {
        boolean isTrackItemValid;
        this.assertIsNotDisPosed();
        this.checkAgainstNull(item);
        T dragStartItem2 = this.dragStartItem;
        boolean bl = isTrackItemValid = !item.equals(this.lastSelectedItem);
        if (isTrackItemValid) {
            boolean shouldShrink = this.contains(item);
            if (shouldShrink) {
                if (this.size() != 1) {
                    this.remove(this.lastSelectedItem);
                }
            } else {
                this.add(item);
            }
            this.lastSelectedItem = item;
        }
        this.dragStartItem = dragStartItem2;
    }

    public void dragTo(T item) {
        boolean isDragItemValid;
        this.assertIsNotDisPosed();
        this.checkAgainstNull(item);
        boolean bl = isDragItemValid = !item.equals(this.lastSelectedItem);
        if (isDragItemValid) {
            if (this.isEmpty()) {
                this.add(item);
                this.dragStartItem = item;
            } else {
                if (this.dragStartItem == null) {
                    this.dragStartItem = this.first();
                }
                this.dragClear();
                this.dragAddAll(this.generateCollection(this.dragStartItem, true, item, true));
            }
            this.lastSelectedItem = item;
        }
    }

    private void dragAddAll(Collection<? extends T> c) {
        T oldDragStartItem = this.dragStartItem;
        this.addAll(c);
        this.dragStartItem = oldDragStartItem;
    }

    private void dragClear() {
        T oldDragStartItem = this.dragStartItem;
        this.clear();
        this.dragStartItem = oldDragStartItem;
    }

    protected abstract Collection<T> generateCollection(T var1, boolean var2, T var3, boolean var4);

    public boolean finalizeSelection() {
        this.assertIsNotDisPosed();
        int newhashCode = this.hashCode();
        if (this.hashCode != newhashCode) {
            this.hashCode = newhashCode;
            this.fireSelectionChanged();
            return true;
        }
        return false;
    }

    public void addListener(SelectionListener listener) {
        this.assertIsNotDisPosed();
        if (listener == null) {
            throw new IllegalArgumentException("listener cant be null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(SelectionListener listener) {
        this.assertIsNotDisPosed();
        if (listener == null) {
            throw new IllegalArgumentException("listener cant be null");
        }
        this.listeners.remove(listener);
    }

    public void fireSelectionChanged() {
        for (SelectionListener listener : this.listeners) {
            listener.selectionChanged();
        }
    }

    public PredicateA<T> getSelectionPredicate() {
        this.assertIsNotDisPosed();
        if (this.selectionPredicate == null) {
            return new TruePredicate();
        }
        return this.selectionPredicate;
    }

    public void setSelectionPredicate(PredicateA<T> selectionPredicate) {
        this.assertIsNotDisPosed();
        this.selectionPredicate = selectionPredicate;
    }

    public final T getLastSelectedItem() {
        this.assertIsNotDisPosed();
        return this.lastSelectedItem;
    }

    private void assertIsNotDisPosed() {
        if (this.isDisposed) {
            throw new IllegalStateException("object is disposed");
        }
    }

    public void dispose() {
        this.assertIsNotDisPosed();
        this.listeners.clear();
        this.lastSelectedItem = null;
        this.selectionPredicate = null;
        this.isDisposed = true;
    }

    @Override
    public Selection<T> clone() {
        this.assertIsNotDisPosed();
        Selection clone = (Selection)super.clone();
        clone.hashCode = this.hashCode;
        clone.isDisposed = this.isDisposed;
        clone.lastSelectedItem = this.lastSelectedItem;
        clone.listeners = new ArrayList<SelectionListener>(this.listeners);
        clone.selectionPredicate = clone.selectionPredicate;
        return clone;
    }

    @Override
    public Comparator<? super T> comparator() {
        this.assertIsNotDisPosed();
        return super.comparator();
    }

    @Override
    public boolean contains(Object o) {
        this.assertIsNotDisPosed();
        return super.contains(o);
    }

    @Override
    public T first() {
        this.assertIsNotDisPosed();
        return (T)super.first();
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        this.assertIsNotDisPosed();
        return super.headSet(toElement);
    }

    @Override
    public boolean isEmpty() {
        this.assertIsNotDisPosed();
        return super.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        this.assertIsNotDisPosed();
        return super.iterator();
    }

    @Override
    public T last() {
        this.assertIsNotDisPosed();
        return (T)super.last();
    }

    @Override
    public boolean remove(Object o) {
        this.assertIsNotDisPosed();
        return super.remove(o);
    }

    @Override
    public int size() {
        this.assertIsNotDisPosed();
        return super.size();
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        this.assertIsNotDisPosed();
        return super.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        this.assertIsNotDisPosed();
        return super.tailSet(fromElement);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.assertIsNotDisPosed();
        return super.removeAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.assertIsNotDisPosed();
        return super.containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.assertIsNotDisPosed();
        return super.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        this.assertIsNotDisPosed();
        return super.toArray();
    }

    public List<T> toList() {
        this.assertIsNotDisPosed();
        return new ArrayList(this);
    }

    @Override
    public <E> E[] toArray(E[] a) {
        this.assertIsNotDisPosed();
        return super.toArray(a);
    }
}

