/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.grid;

import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import ca.infodata.ofys.ui.controls.grid.Grid;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NormalCellRenderer<T extends Cell>
implements CellRenderer<T, GridData<?>> {
    public static boolean drawText = true;
    private Color colorSelection;
    private Color colorBackground;
    private Color colorBorder;

    public NormalCellRenderer(Color colorSelection, Color colorBackground, Color colorBorder) {
        this.colorSelection = colorSelection;
        this.colorBackground = colorBackground;
        this.colorBorder = colorBorder;
    }

    @Override
    public void render(T cell, Grid<?, ?> grid, GridData<?> gridData, Rectangle rect, GC gc, boolean selected) {
        if (this.getColorSelection() == null || this.getColorBackground() == null || this.getColorBorder() == null) {
            throw new IllegalStateException("color is null");
        }
        if (selected) {
            gc.setBackground(this.getColorSelection());
        } else {
            gc.setBackground(this.getColorBackground());
        }
        gc.fillRectangle(rect);
        gc.setForeground(this.getColorBorder());
        gc.setLineWidth(1);
        gc.drawRectangle(rect);
    }

    public Color getColorSelection() {
        return this.colorSelection;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public void setColorSelection(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorSelection = color;
    }

    public void setColorBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorBackground = color;
    }

    public void setColorBorder(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cant be null");
        }
        this.colorBorder = color;
    }

    @Override
    public void dispose() {
        if (this.colorBorder != null) {
            ResourceGetter.dispose((Object)this.colorBorder);
        }
        if (this.colorBackground != null) {
            ResourceGetter.dispose((Object)this.colorBackground);
        }
        if (this.colorSelection != null) {
            ResourceGetter.dispose((Object)this.colorSelection);
        }
    }
}

